package com.nortel.rc.dao;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.exception.DAOException;

public interface IRoutePointConnectionServiceDAO extends IServiceDAO
{
	public CallResult retrieve(AddressTO addr, ConnectionTO conn, String sso)
		throws DAOException;
	
	public CallResult route(String addr, ConnectionTO conn, String sso)
		throws DAOException;
	
	public CallResult giveMediaTreatment(String treatmentTerminal, String treatmentAddress, ConnectionTO connection, String type, String sso)
		throws DAOException;
	
	public CallResult getCapabilities(ConnectionTO connection, String sso)
		throws DAOException;
}
