package com.nortel.rc.dao;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;

import org.apache.commons.lang.StringUtils;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.oasis_open.docs.wsrf._2004._06.wsrf_ws_resourceproperties_1_2_draft_01.QueryExpressionType;
import org.xmlsoap.schemas.ws._2003._03.addressing.AttributedURI;
import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;
import org.xmlsoap.schemas.ws._2003._03.addressing.ObjectFactory;
import org.xmlsoap.schemas.ws._2003._03.addressing.ServiceNameType;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.event.NotificationHandler;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.basenotification.AddressPropertyListenerType;
import com.nortel.soa.oi.cct.basenotification.AddressStateListenerType;
import com.nortel.soa.oi.cct.basenotification.AgentPropertyListenerType;
import com.nortel.soa.oi.cct.basenotification.AgentStateListenerType;
import com.nortel.soa.oi.cct.basenotification.ConnectionStateListenerType;
import com.nortel.soa.oi.cct.basenotification.ContactPropertyListenerType;
import com.nortel.soa.oi.cct.basenotification.NotificationTopicType;
import com.nortel.soa.oi.cct.basenotification.TerminalConnectionStateListenerType;
import com.nortel.soa.oi.cct.basenotification.TerminalPropertyListenerType;
import com.nortel.soa.oi.cct.basenotification.TerminalStateListenerType;
import com.nortel.soa.oi.cct.basenotification.TopicExpressionType;
import com.nortel.soa.oi.cct.notification.SubscriptionPolicyType;
import com.nortel.soa.oi.cct.notificationproducer.NotificationProducer;
import com.nortel.soa.oi.cct.notificationproducer.SOAOICCTNotificationProducer;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressProperty;
import com.nortel.soa.oi.cct.types.Agent;
import com.nortel.soa.oi.cct.types.AgentProperty;
import com.nortel.soa.oi.cct.types.AgentState;
import com.nortel.soa.oi.cct.types.ConnectionState;
import com.nortel.soa.oi.cct.types.ContactProperty;
import com.nortel.soa.oi.cct.types.ResourceState;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalConnectionState;
import com.nortel.soa.oi.cct.types.TerminalProperty;

public class NotificationDAO extends ServiceDAO implements INotificationDAO
{
	private static Logger logger = Logger.getLogger("rc.dao.ContactServiceDAO");
	private String endPoint = null;
	private QName consumerServiceQName;
	private QName producerServiceQName;
	private String uriForNorify;
	private String consumerServicePortName;
	private String topicExpressionDialect;
	
	EndpointReferenceType subscriptionRef = null;

	public void subscribe(List<TerminalTO> terminals,  List<AddressTO> addresses, String sso) throws DAOException
	{
		String methodName = "subscribe():"; 
		SsoToken ssoToken = new SsoToken();
		ssoToken.setToken(sso);
		
		ObjectFactory WSA_OBJ_FACTORY =  new ObjectFactory();
		
		EndpointReferenceType consumerReference = WSA_OBJ_FACTORY.createEndpointReferenceType();
   	
		AttributedURI uri = WSA_OBJ_FACTORY.createAttributedURI();
		uri.setValue(getUriForNorify());	
		    	
		ServiceNameType serviceName = WSA_OBJ_FACTORY.createServiceNameType();
		serviceName.setValue(getConsumerServiceQName());
		serviceName.setPortName(getConsumerServicePortName());
		
		consumerReference.setAddress(uri);
		consumerReference.setServiceName(serviceName);
		
		//Specify the Address Entities for the desired ListenerEntities
		List<Address> connectionStateListenerEntities = new ArrayList<Address>();
		List<ConnectionState> connectionStateListenerProperties = new ArrayList<ConnectionState>();
		
		List<Terminal> terminalConnectionStateListenerEntities = new ArrayList<Terminal>();		
		List<TerminalConnectionState> terminalConnectionStateListenerProperties = new ArrayList<TerminalConnectionState>();
		
		List<Address> addressPropertyListenerEntities = new ArrayList<Address>();
		List<AddressProperty> addressPropertyListenerProperties = new ArrayList<AddressProperty>();

		List<Terminal> terminalPropertyListenerEntities = new ArrayList<Terminal>();
		List<TerminalProperty> terminalPropertyListenerProperties =	new ArrayList<TerminalProperty>();
		
		List<Agent> agentPropertyListenerEntities = new ArrayList<Agent>();
		List<AgentProperty> agentPropertyListenerProperties =	new ArrayList<AgentProperty>();
		
		List<Address> contactPropertyListenerEntities = new ArrayList<Address>();
		List<ContactProperty> contactPropertyListenerProperties = new ArrayList<ContactProperty>();
		
		List<ResourceState> addressStateListenerProperties =	new ArrayList<ResourceState>();
		List<ResourceState> terminalStateListenerProperties =	new ArrayList<ResourceState>();
		List<AgentState> agentStateListenerProperties =	new ArrayList<AgentState>();
		
		//Add the terminals
//		for(TerminalTO terminal : terminals)
//		{	
//			Terminal term = new Terminal();
//			term.setTerminalName(terminal.getTerminalName());
//			term.setTerminalType(TerminalType.valueOf(terminal.getTerminalType()));
//			
//			terminalPropertyListenerEntities.add(term);
//			terminalConnectionStateListenerEntities.add(term);
//			
//			//Add the addresses of the terminals
//			for(AddressTO address : terminal.getAddresses())
//			{
//				Address addr = new Address();
//				addr.setAddressName(address.getAddressName());
//				addr.setAddressType(AddressType.valueOf(address.getAddressType()));
//				
//				connectionStateListenerEntities.add(addr);
//				addressPropertyListenerEntities.add(addr);
//				contactPropertyListenerEntities.add(addr);
//			}
//		}
		
		//Add the unmapped addresses
//		for(AddressTO unmappedAddress : addresses)
//		{
//			Address addr = new Address();
//			addr.setAddressName(unmappedAddress.getAddressName());
//			addr.setAddressType(AddressType.valueOf(unmappedAddress.getAddressType()));
//			
//			connectionStateListenerEntities.add(addr);
//			addressPropertyListenerEntities.add(addr);
//			contactPropertyListenerEntities.add(addr);
//		}
		
		TopicExpressionType topicExpression = createTopicExpression( 
				addressPropertyListenerProperties, addressPropertyListenerEntities, 
				terminalPropertyListenerProperties, terminalPropertyListenerEntities,
				agentPropertyListenerProperties, agentPropertyListenerEntities,
				contactPropertyListenerProperties, contactPropertyListenerEntities,
				connectionStateListenerProperties, connectionStateListenerEntities, 
				terminalConnectionStateListenerProperties, terminalConnectionStateListenerEntities,
				addressStateListenerProperties,
				terminalStateListenerProperties,
				agentStateListenerProperties,
				getTopicExpressionDialect());
		
		Boolean useNotify = true;
		QueryExpressionType precondition = null;
		QueryExpressionType selector = null;
		
		XMLGregorianCalendar initialTerminationTime = null;
//		try {
//			initialTerminationTime = DatatypeFactory.newInstance().newXMLGregorianCalendar();
//		} catch (DatatypeConfigurationException e) {
//		}
//		
//		if(initialTerminationTime != null)
//		{
//			Calendar now = Calendar.getInstance();
//			initialTerminationTime.setDay(now.get(Calendar.DAY_OF_MONTH));
//			initialTerminationTime.setMonth(now.get(Calendar.MONTH)+1);
//			initialTerminationTime.setYear(now.get(Calendar.YEAR));
//			initialTerminationTime.setTime(now.get(Calendar.HOUR_OF_DAY)+1,
//													now.get(Calendar.MINUTE)+5, 
//													now.get(Calendar.SECOND));
//		}
		
		SubscriptionPolicyType subPolicy = new SubscriptionPolicyType();
		subPolicy.setConnectionFailureNotificationsEnabled(true);
		//subPolicy.setProducerRestartNotificationsEnabled(true);
		subPolicy.setSubscriptionTerminationImminentNotificationsEnabled(true);
		subPolicy.setSessionTerminationImminentNotificationsEnabled(true);
		
		try
		{
	        subscriptionRef = getPort().subscribe(consumerReference, topicExpression, useNotify, precondition,
									selector, subPolicy, initialTerminationTime, ssoToken);
	        
	        NotificationHandler.SUBSCRIPTION_ID = subscriptionRef.getSubscriptionId();
		} catch (Exception e) {
			logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	}

	public void unSubscribe(String sso) throws DAOException
	{
		String methodName = "unSubscribe():"; 
		SsoToken ssoToken = new SsoToken();
		ssoToken.setToken(sso);
		
		try
		{
			getPort().unsubscribe(subscriptionRef, ssoToken);
		} catch (Exception e) {
			logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	}
	
	public void unSubscribe(String sso, String specificSubscriptionId) throws DAOException
	{
		String methodName = "unSubscribe(specificSubscriptionId):"; 
		SsoToken ssoToken = new SsoToken();
		ssoToken.setToken(sso);
				
		String validSubId = subscriptionRef.getSubscriptionId();		
		subscriptionRef.setSubscriptionId(specificSubscriptionId);
		
		try
		{
			getPort().unsubscribe(subscriptionRef, ssoToken);
		} catch (Exception e) {
			logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    	subscriptionRef.setSubscriptionId(validSubId);
	    }
	}
	
	public void renew(String sso, String specificSubscriptionId) throws DAOException
	{
		String methodName = "renew():"; 
		SsoToken ssoToken = new SsoToken();
		ssoToken.setToken(sso);
		
		String validSubId = subscriptionRef.getSubscriptionId();		
		subscriptionRef.setSubscriptionId(specificSubscriptionId);
		
		try
		{
			getPort().renew(subscriptionRef, ssoToken, new Holder<XMLGregorianCalendar>(), new Holder<XMLGregorianCalendar>());
		} catch (Exception e) {
			logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
			subscriptionRef.setSubscriptionId(validSubId);
		}
		
	}

	/**
	 * Retrieves interface to be used by service consumers
	 */
	public NotificationProducer getPort() throws DAOException
	{		
		if(endPoint == null)
		{										
			SOAOICCTNotificationProducer ss = new SOAOICCTNotificationProducer(getWsdlUrl(), getProducerServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
		
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(NotificationProducer.class);
		NotificationProducer service = (NotificationProducer) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);

		return service;
	}

	/**
	 * @param topicExpressionDialect the topicExpressionDialect to set
	 */
	public void setTopicExpressionDialect(String topicExpressionDialect) {
		this.topicExpressionDialect = topicExpressionDialect;
	}
	
	public static TopicExpressionType createTopicExpression(
    		List<AddressProperty> addressPropertyListenerEvents,
    		List<Address> addressPropertyListenerEntities,
    		List<TerminalProperty> terminalPropertyListenerEvents,
    		List<Terminal> terminalPropertyListenerEntities,
    		List<AgentProperty> agentPropertyListenerEvents,
    		List<Agent> agentPropertyListenerEntities,
    		List<ContactProperty> contactPropertyListenerEvents,
    		List<Address> contactPropertyListenerEntities,
    		List<ConnectionState> connectionStateListenerEvents,
    		List<Address> connectionStateListenerEntities,
    		List<TerminalConnectionState> terminalConnectionStateListenerEvents,
    		List<Terminal> terminalConnectionStateListenerEntities,
    		List<ResourceState> addressStateListenerEvents,
    		List<ResourceState> terminalStateListenerEvents,
    		List<AgentState> agentStateListenerEvents,
    		String topicExpressionDialect) 
	{	    
	    com.nortel.soa.oi.cct.basenotification.ObjectFactory WSBN_OBJ_FACTORY = 
	    	new com.nortel.soa.oi.cct.basenotification.ObjectFactory();
    	
    	boolean addressPropertyReg = false;
    	boolean terminalPropertyReg = false;
    	boolean agentPropertyReg = false;
    	boolean contactPropertyReg = false;
    	boolean connectionStateReg = false;
    	boolean terminalConnectionStateReg = false;
    	boolean addressStateReg = false;
    	boolean terminalStateReg = false;
    	boolean agentStateReg = false;
    	
    	//boolean forceDisconnectReg = false;
    	//boolean providerStateReg = false;
    	
        TopicExpressionType topicExpression = null;
    	
    	AddressPropertyListenerType addressPropertyListener = WSBN_OBJ_FACTORY.createAddressPropertyListenerType();
    	if( addressPropertyListenerEvents != null ) {
    		addressPropertyListener.getAddressPropertyEvent().addAll(addressPropertyListenerEvents);	
    		addressPropertyReg = true;
    	}
    	if( addressPropertyListenerEntities != null ) {
    		addressPropertyListener.getAddressEntity().addAll(addressPropertyListenerEntities);
    		addressPropertyReg = true;
    	}
    	
    	TerminalPropertyListenerType terminalPropertyListener = WSBN_OBJ_FACTORY.createTerminalPropertyListenerType();
    	if( terminalPropertyListenerEvents != null ) {
    		terminalPropertyListener.getTerminalPropertyEvent().addAll(terminalPropertyListenerEvents);
    		terminalPropertyReg = true;
    	}
    	if( terminalPropertyListenerEntities != null ) {
    		terminalPropertyListener.getTerminalEntity().addAll(terminalPropertyListenerEntities);
    		terminalPropertyReg = true;
    	}
    	
    	AgentPropertyListenerType agentPropertyListener = WSBN_OBJ_FACTORY.createAgentPropertyListenerType();
    	if( agentPropertyListenerEvents != null ) {
    		agentPropertyListener.getAgentPropertyEvent().addAll(agentPropertyListenerEvents);
    		agentPropertyReg = true;
    	}
    	if( agentPropertyListenerEntities != null ) {
    		agentPropertyListener.getAgentEntity().addAll(agentPropertyListenerEntities);
    		agentPropertyReg = true;
    	}
    	    	
    	ContactPropertyListenerType contactPropertyListener = WSBN_OBJ_FACTORY.createContactPropertyListenerType();
    	if( contactPropertyListenerEvents != null ) {
    		contactPropertyListener.getContactPropertyEvent().addAll(contactPropertyListenerEvents);
    		contactPropertyReg = true;
    	}
    	if( contactPropertyListenerEntities != null ) {
    		contactPropertyListener.getAddressEntity().addAll(contactPropertyListenerEntities);
    		contactPropertyReg = true;
    	} 	

    	ConnectionStateListenerType connectionStateListener = WSBN_OBJ_FACTORY.createConnectionStateListenerType();
    	if( connectionStateListenerEvents != null ) {
    		connectionStateListener.getConnectionStateEvent().addAll(connectionStateListenerEvents);
    		connectionStateReg = true;
    	}
    	if( connectionStateListenerEntities != null ) {
    		connectionStateListener.getAddressEntity().addAll(connectionStateListenerEntities);
    		connectionStateReg = true;
    	} 	

    	TerminalConnectionStateListenerType terminalConnectionStateListener = WSBN_OBJ_FACTORY.createTerminalConnectionStateListenerType();
    	if( terminalConnectionStateListenerEvents != null ) {
    		terminalConnectionStateListener.getTerminalConnectionStateEvent().addAll(terminalConnectionStateListenerEvents);
    		terminalConnectionStateReg = true;
    	}
    	if( terminalConnectionStateListenerEntities != null ) {
    		terminalConnectionStateListener.getTerminalEntity().addAll(terminalConnectionStateListenerEntities);
    		terminalConnectionStateReg = true;
    	}
    	
    	AddressStateListenerType addressStateListener = WSBN_OBJ_FACTORY.createAddressStateListenerType();
    	if( addressStateListenerEvents != null ) {
    		addressStateListener.getState().addAll(addressStateListenerEvents);
    		addressStateReg = true;
    	}
    	
    	TerminalStateListenerType terminalStateListener = WSBN_OBJ_FACTORY.createTerminalStateListenerType();
    	if( terminalStateListenerEvents != null ) {
    		terminalStateListener.getState().addAll(terminalStateListenerEvents);
    		terminalStateReg = true;
    	}
    	
    	AgentStateListenerType agentStateListener = WSBN_OBJ_FACTORY.createAgentStateListenerType();
    	if( agentStateListenerEvents != null ) {
    		agentStateListener.getState().addAll(agentStateListenerEvents);
    		agentStateReg = true;
    	}
    	
    	///////////////////////////////////////////////////////////////////////////////////////////////////////////////    	
    	//ServiceProviderStatusListenerType serviceProviderStatusListener = WSBN_OBJ_FACTORY.createServiceProviderStatusListenerType();    	
    	//serviceProviderStatusListener.getProviderEntity().addAll(new ArrayList<Provider>());
    	///////////////////////////////////////////////////////////////////////////////////////////////////////////////
    	
    	NotificationTopicType notificationTopic = WSBN_OBJ_FACTORY.createNotificationTopicType();
    	
    	if ( addressPropertyReg ) {
    		notificationTopic.setAddressPropertyListener(addressPropertyListener);
    	}
    	if ( terminalPropertyReg ) {
    		notificationTopic.setTerminalPropertyListener(terminalPropertyListener);
    	}
    	if ( agentPropertyReg ) {
    		notificationTopic.setAgentPropertyListener(agentPropertyListener);
    	}
    	if ( contactPropertyReg ) {
    		notificationTopic.setContactPropertyListener(contactPropertyListener);
    	}
    	if ( connectionStateReg ) {
    		notificationTopic.setConnectionStateListener(connectionStateListener);
    	}
    	if ( terminalConnectionStateReg ) {
    		notificationTopic.setTerminalConnectionStateListener(terminalConnectionStateListener);
    	}
    	if ( addressStateReg ) {
    		notificationTopic.setAddressStateListener(addressStateListener);
    	}
    	if ( terminalStateReg ) {
    		notificationTopic.setTerminalStateListener(terminalStateListener);
    	}
    	if ( agentStateReg ) {
    		notificationTopic.setAgentStateListener(agentStateListener);
    	}
    	
    	//notificationTopic.setServiceProviderStatusListener(serviceProviderStatusListener);
    	    	
    	topicExpression = WSBN_OBJ_FACTORY.createTopicExpressionType();
    	topicExpression.setDialect(topicExpressionDialect);
    	topicExpression.getContent().add(WSBN_OBJ_FACTORY.createTopicExpressionTypeNotificationTopic(notificationTopic));    	
    	
    	return topicExpression;
    }
	
	/**
	 * @return the serviceQName
	 */
	public QName getProducerServiceQName() {
		return producerServiceQName;
	}

	/**
	 * @param serviceQName the serviceQName to set
	 */
	public void setProducerServiceQName(QName producerServiceQName) {
		this.producerServiceQName = producerServiceQName;
	}
	
	/**
	 * @return the serviceQName
	 */
	public QName getConsumerServiceQName() {
		return consumerServiceQName;
	}

	/**
	 * @param serviceQName the serviceQName to set
	 */
	public void setConsumerServiceQName(QName consumerServiceQName) {
		this.consumerServiceQName = consumerServiceQName;
	}

	/**
	 * @return the uriForNorify
	 */
	public String getUriForNorify() {
		return uriForNorify;
	}

	/**
	 * @param uriForNorify the uriForNorify to set
	 */
	public void setUriForNorify(String uri)
	{
		uriForNorify = uri;
		uriForNorify = StringUtils.replace(uriForNorify, "HOSTNAME", NotificationHandler.NOTIFICATIONS_HOSTNAME);
		uriForNorify = StringUtils.replace(uriForNorify, "PORT", NotificationHandler.NOTIFICATIONS_PORT);
	}

	/**
	 * @return the topicExpressionDialect
	 */
	public String getTopicExpressionDialect() {
		return topicExpressionDialect;
	}

	/**
	 * @return the consumerServicePortName
	 */
	public String getConsumerServicePortName() {
		return consumerServicePortName;
	}

	/**
	 * @param consumerServicePortName the consumerServicePortName to set
	 */
	public void setConsumerServicePortName(String consumerServicePortName) {
		this.consumerServicePortName = consumerServicePortName;
	}
}
