package com.nortel.rc.dto;

import java.util.ArrayList;
import java.util.List;

public class ContactTO {

	private String contactId;
	private String externalContactId;
	private String calledAddress;
	private String callingAddress;
	private String callingTerminal;
	private String lastRedirectedAddress;
	private String originalDestinationAddress;
	private AttachedDataTO attachedData;
	private String uuiData;
	private List<IntrinsicTO> intrinsicData;
	private List<String> contactTypes;
	private List<ConnectionTO> connections = new ArrayList<ConnectionTO>();
	private ContactCapabilitiesTO contactCapabilities;

	/**
	 * @return the contactId
	 */
	public String getContactId() {
		return contactId;
	}

	/**
	 * @param contactId the contactId to set
	 */
	public void setContactId(String contactId) {
		this.contactId = contactId;
	}

	/**
	 * @return the contactCapabilities
	 */
	public ContactCapabilitiesTO getCapabilities() {
		return contactCapabilities;
	}

	/**
	 * @param contactCapabilities the contactCapabilities to set
	 */
	public void setCapabilities(ContactCapabilitiesTO contactCapabilities) {
		this.contactCapabilities = contactCapabilities;
	}

	public ConnectionTO getConnection(String address)
	{
		ConnectionTO conn = null;
		for(ConnectionTO cTO : connections)
		{
			if(cTO.getAddressName().equals(address))
			{
				conn = cTO;
				break;
			}
		}
		return conn;
	}
	
	public TerminalConnectionTO getTerminalConnection(String terminal, String address)
	{
		TerminalConnectionTO termConn = null;
		for(ConnectionTO cTO : connections)
		{
			if(cTO.getAddressName().equals(address))
			{
				for(TerminalConnectionTO tcTO : cTO.getTerminalConnections())
				{
					if(tcTO.getTerminalName().equals(terminal))
					{
						termConn = tcTO;
						break;
					}
				}
			}
		}
		return termConn;
	}
	
	public TerminalConnectionTO getTerminalConnectionByName(String terminal)
	{
		TerminalConnectionTO termConn = null;
		search:
		for(ConnectionTO cTO : connections)
		{
			for(TerminalConnectionTO tcTO : cTO.getTerminalConnections())
			{
				if(tcTO.getTerminalName().equals(terminal))
				{
					termConn = tcTO;
					break search;
				}
			}
		}
		return termConn;
	}
	
	/**
	 * @return the connection
	 */
	public ConnectionTO getConnectionById(String id) {
		ConnectionTO conn = null;
		for(ConnectionTO cTO : connections)
		{
			if(cTO.getConnectionId().equals(id))
			{
				conn = cTO;
				break;
			}
		}
		return conn;
	}
	
	/**
	 * @return the connection
	 */
	public void setConnection(ConnectionTO connectionToSet)
	{
		int foundAtIndex = -1;
		for(int i=0; i<connections.size(); i++)
		{
			if(connections.get(i).getConnectionId().equals(connectionToSet.getConnectionId()))
			{
				foundAtIndex = i;
				break;
			}
		}
		if(foundAtIndex > -1)
		{
			connections.set(foundAtIndex, connectionToSet);
		}
	}

	/**
	 * @param connection the connection to set
	 */
	public void addConnection(ConnectionTO connection) {
		this.connections.add(connection);
	}

	/**
	 * @return the calledAddress
	 */
	public String getCalledAddress() {
		return calledAddress;
	}

	/**
	 * @param calledAddress the calledAddress to set
	 */
	public void setCalledAddress(String calledAddress) {
		this.calledAddress = calledAddress;
	}

	/**
	 * @return the callingAddress
	 */
	public String getCallingAddress() {
		return callingAddress;
	}

	/**
	 * @param callingAddress the callingAddress to set
	 */
	public void setCallingAddress(String callingAddress) {
		this.callingAddress = callingAddress;
	}

	/**
	 * @return the callingTerminal
	 */
	public String getCallingTerminal() {
		return callingTerminal;
	}

	/**
	 * @param callingTerminal the callingTerminal to set
	 */
	public void setCallingTerminal(String callingTerminal) {
		this.callingTerminal = callingTerminal;
	}

	/**
	 * @return the lastRedirectedAddress
	 */
	public String getLastRedirectedAddress() {
		return lastRedirectedAddress;
	}

	/**
	 * @param lastRedirectedAddress the lastRedirectedAddress to set
	 */
	public void setLastRedirectedAddress(String lastRedirectedAddress) {
		this.lastRedirectedAddress = lastRedirectedAddress;
	}

	/**
	 * @return the originalDestinationAddress
	 */
	public String getOriginalDestinationAddress() {
		return originalDestinationAddress;
	}

	/**
	 * @param originalDestinationAddress the originalDestinationAddress to set
	 */
	public void setOriginalDestinationAddress(String originalDestinationAddress) {
		this.originalDestinationAddress = originalDestinationAddress;
	}

	/**
	 * @return the contactTypes
	 */
	public List<String> getContactTypes() {
		return contactTypes;
	}

	/**
	 * @param contactTypes the contactTypes to set
	 */
	public void setContactTypes(List<String> contactTypes) {
		this.contactTypes = contactTypes;
	}

	/**
	 * @param connections the connections to set
	 */
	public void setConnections(List<ConnectionTO> connections) {
		this.connections = connections;
	}

	/**
	 * @return the connections
	 */
	public List<ConnectionTO> getConnections() {
		return connections;
	}

	/**
	 * @return the externalContactId
	 */
	public String getExternalContactId() {
		return externalContactId;
	}

	/**
	 * @param externalContactId the externalContactId to set
	 */
	public void setExternalContactId(String externalContactId) {
		this.externalContactId = externalContactId;
	}

	/**
	 * @return the uuiData
	 */
	public String getUuiData() {
		return uuiData;
	}

	/**
	 * @param uuiData the uuiData to set
	 */
	public void setUuiData(String uuiData) {
		this.uuiData = uuiData;
	}

	/**
	 * @return the intrinsicData
	 */
	public List<IntrinsicTO> getIntrinsicData() {
		return intrinsicData;
	}

	/**
	 * @param intrinsicData the intrinsicData to set
	 */
	public void setIntrinsicData(List<IntrinsicTO> intrinsicData) {
		this.intrinsicData = intrinsicData;
	}

	/**
	 * @return the attachedData
	 */
	public AttachedDataTO getAttachedData() {
		return attachedData;
	}

	/**
	 * @param attachedData the attachedData to set
	 */
	public void setAttachedData(AttachedDataTO attachedData) {
		this.attachedData = attachedData;
	}
}
