//////////////////////////////////////////////////////////////////////////////
// NotificationHandler.java
//
// Avaya Inc. - Proprietary (Restricted)
// Solely for authorized persons having a need to know
// pursuant to Company instructions.
//
// Copyright  2008-2013 Avaya Inc. All rights reserved.
// THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
// The copyright notice above does not evidence any actual
// or intended publication of such source code.
//////////////////////////////////////////////////////////////////////////////
package com.nortel.rc.event;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;

import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType;
import com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer;

@WebService(name = "NotificationConsumer", serviceName = "SOAOICCT_NotificationConsumer", portName = "NotificationConsumer", targetNamespace = "http://www.nortel.com/soa/oi/cct/NotificationConsumer", endpointInterface = "com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer")
public final class NotificationHandler implements NotificationConsumer, INotificationHandler
{
	public static String NOTIFICATIONS_HOSTNAME;
	public static String NOTIFICATIONS_PORT;
	public static String SUBSCRIPTION_ID;

	private static Logger logger = Logger.getLogger(NotificationHandler.class.getName());

	private NotificationManager notificationManager;

	public NotificationHandler(final String defaultPort)
	{
		String hostname = null;

		try
		{
			InetAddress addr = InetAddress.getLocalHost();
			hostname = addr.getHostAddress();
		}
		catch (final UnknownHostException e)
		{
			hostname = "localhost";
		}
		String predefinedPort = System.getProperty("notification.port");
		String portToUse = (predefinedPort == null || "".equals(predefinedPort)) ? findAvailablePort(defaultPort) : predefinedPort;

		// Set the static host and port for use by the DAO
		setStaticHostname(hostname);
		setStaticPort(portToUse);

		String consumerAddress = "http://" + hostname + ":" + portToUse + "/SOAOICCT/services/NotificationConsumer";

		logger.log(Level.INFO, "Publishing NotificationHandler: " + consumerAddress);
		Endpoint.publish(consumerAddress, this);
	}

	@WebMethod
	public void notify(final java.util.List<com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType> notificationMessageHolderList)
	{
		notificationManager.handleNotify(notificationMessageHolderList);
	}

	private static void setStaticHostname(final String hostName)
	{
		NOTIFICATIONS_HOSTNAME = hostName;
	}

	private static void setStaticPort(final String port)
	{
		NOTIFICATIONS_PORT = port;
	}

	/**
	 * Tries to find any free port on the system. If fails, <b>defaultPort</b> is returned.
	 * @param defaultPort
	 * @return
	 */
	public static String findAvailablePort(final String defaultPort)
	{
		ServerSocket server = null;
		String port = defaultPort;

		try
		{
			server = new ServerSocket(0);
			port = Integer.toString(server.getLocalPort());
		}
		catch (final IOException e)
		{
			logger.error("findAvailablePort(): Exception while creating server socket: ", e);
		}
		finally
		{
			try
			{
				if (server != null && !server.isClosed())
				{
					server.close();
				}
			}
			catch (final IOException e)
			{
				logger.error("findAvailablePort(): Exception while closing server socket: ", e);
			}
		}

		return port;
	}

	public NotificationManager getNotificationManager()
	{
		return notificationManager;
	}

	public void setNotificationManager(final NotificationManager notificationManager)
	{
		this.notificationManager = notificationManager;
	}
}
