package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.TerminalTO;

public class GenerateDTMFCommand extends Command 
{
	private IContactDAO contactDAO;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		TerminalTO term = (TerminalTO)params.get("terminal");
		ContactTO contact = new ContactTO();
		contact.setContactId((String)params.get("contactId"));
		String digits = (String)params.get("GenerateDTMF_digits");
				
		getContactDAO().generateDTMF(term, contact, digits, ssoToken);	
	}

	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}	
}