package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IAddressServiceDAO;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.soa.oi.cct.types.AddressType;

public class GetAddressStateCommand extends Command 
{
	private IAddressServiceDAO addressServiceDAO;
	private ICapabilitiesFacade capabilitiesFacade;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		AddressTO address = (AddressTO)params.get("address");
		getCapabilitiesFacade().getCapabilities(address, ssoToken);
		
		CallResult cr = getAddressServiceDAO().getTerminals(address, ssoToken);
		List<TerminalTO> terminals = null;
		if(!address.getAddressType().equals(AddressType.ROUTE_POINT.name()))
		{
			terminals = (List<TerminalTO>)cr.getObject();
		}
		
		getRefClient().addNewAddress(terminals, address);
	}

	/**
	 * @return the addressServiceDAO
	 */
	public IAddressServiceDAO getAddressServiceDAO() {
		return addressServiceDAO;
	}

	/**
	 * @param addressServiceDAO the addressServiceDAO to set
	 */
	public void setAddressServiceDAO(IAddressServiceDAO addressServiceDAO) {
		this.addressServiceDAO = addressServiceDAO;
	}

	/**
	 * @return the capabilitiesFacade
	 */
	public ICapabilitiesFacade getCapabilitiesFacade() {
		return capabilitiesFacade;
	}

	/**
	 * @param capabilitiesFacade the capabilitiesFacade to set
	 */
	public void setCapabilitiesFacade(ICapabilitiesFacade capabilitiesFacade) {
		this.capabilitiesFacade = capabilitiesFacade;
	}
}
