package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IRoutePointAddressServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;

public class GetRoutePointAcquiredStatusCommand extends Command 
{
	private IRoutePointAddressServiceDAO routePointAddressServiceDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		AddressTO address = (AddressTO)params.get("address");
		CallResult cr = getRoutePointAddressServiceDAO().isControlled(address, ssoToken);
		address.setControlled(((Boolean)cr.getObject()).booleanValue());
		
		//Update the UI with the result
		getRefClient().updateRoutePointContextWithSingle(address);
	}

	/**
	 * @return the routePointAddressServiceDAO
	 */
	public IRoutePointAddressServiceDAO getRoutePointAddressServiceDAO() {
		return routePointAddressServiceDAO;
	}

	/**
	 * @param routePointAddressServiceDAO the routePointAddressServiceDAO to set
	 */
	public void setRoutePointAddressServiceDAO(
			IRoutePointAddressServiceDAO routePointAddressServiceDAO) {
		this.routePointAddressServiceDAO = routePointAddressServiceDAO;
	}
}
