package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dao.ITerminalServiceDAO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalCapabilitiesTO;
import com.nortel.rc.dto.TerminalTO;

public class GetTerminalStateCommand extends Command 
{
	private IAgentTerminalServiceDAO agentTerminalServiceDAO;
	private ITerminalServiceDAO terminalServiceDAO;
	private ICapabilitiesFacade capabilitiesFacade;
	private IContactDAO contactDAO;	
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		TerminalTO terminal = (TerminalTO)params.get("terminal");
		CallResult cr;
		
		cr = getAgentTerminalServiceDAO().isLoggedIn(terminal, ssoToken);
		terminal.setAgentLoggedIn(((Boolean)cr.getObject()).booleanValue());
		cr = getAgentTerminalServiceDAO().isReady(terminal, ssoToken);
		terminal.setTerminalReady(((Boolean)cr.getObject()).booleanValue());
		
		if (terminal.isAgentLoggedIn()){
			cr = getAgentTerminalServiceDAO().getLoginId(terminal, ssoToken);
			terminal.setLoginId(cr.getObject().toString());
		}	
		
		TerminalCapabilitiesTO capabilities = terminal.getTerminalCapabilities();
		if (capabilities!= null && capabilities.isCanForward()) {
			cr = getTerminalServiceDAO().isForwarded(terminal, ssoToken);
			terminal.setForwarding(((Boolean)cr.getObject()).booleanValue());					
		}

		//May not have capability to getDoNotDisturb
		//e.g. Default Terminals when Blended Agent logs in		
		if (capabilities!= null && capabilities.isCanDoNotDisturb()) {
			cr = getTerminalServiceDAO().getDoNotDisturb(terminal, ssoToken);
			terminal.setDoNotDisturb(((Boolean)cr.getObject()).booleanValue());
		}
		
		cr = getTerminalServiceDAO().getContactTypes(terminal, ssoToken);
		terminal.setContactTypes(((List<String>)cr.getObject()));
		
		//Get the addresses (along with their capabilities) for the new Terminal
		//Notifications should arrive for these Addresses (can't be sure they haven't already)
		List<AddressTO> addresses = getContactDAO().getTerminalAddresses(terminal, ssoToken);
		for(int i=0; i<addresses.size(); i++)
		{
			getCapabilitiesFacade().getCapabilities(addresses.get(i), ssoToken);
		}
		terminal.setAddresses(addresses);
		
		getRefClient().addNewTerminal(terminal);
	}

	/**
	 * @return the agentTerminalServiceDAO
	 */
	public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
		return agentTerminalServiceDAO;
	}

	/**
	 * @param agentTerminalServiceDAO the agentTerminalServiceDAO to set
	 */
	public void setAgentTerminalServiceDAO(
			IAgentTerminalServiceDAO agentTerminalServiceDAO) {
		this.agentTerminalServiceDAO = agentTerminalServiceDAO;
	}

	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}

	/**
	 * @return the terminalServiceDAO
	 */
	public ITerminalServiceDAO getTerminalServiceDAO() {
		return terminalServiceDAO;
	}

	/**
	 * @param terminalServiceDAO the terminalServiceDAO to set
	 */
	public void setTerminalServiceDAO(ITerminalServiceDAO terminalServiceDAO) {
		this.terminalServiceDAO = terminalServiceDAO;
	}

	/**
	 * @return the capabilitiesFacade
	 */
	public ICapabilitiesFacade getCapabilitiesFacade() {
		return capabilitiesFacade;
	}

	/**
	 * @param capabilitiesFacade the capabilitiesFacade to set
	 */
	public void setCapabilitiesFacade(ICapabilitiesFacade capabilitiesFacade) {
		this.capabilitiesFacade = capabilitiesFacade;
	}

	
}
