package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dto.IntrinsicTO;

public class SetIntrinsicDataCommand extends Command 
{
	private IContactServiceDAO contactServiceDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		List<IntrinsicTO> data = (List<IntrinsicTO>)params.get("intrinsicData");
		getContactServiceDAO().setIntrinsicData((String)params.get("contactId"), data, ssoToken);	
	}

	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}
}