package com.nortel.rc.dao;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.addressservice.AddressService;
import com.nortel.soa.oi.cct.addressservice.SOAOICCTAddressService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressCapabilities;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.addressservice.AddressRequest;
import com.nortel.soa.oi.cct.types.addressservice.GetConnectionsResponse;
import com.nortel.soa.oi.cct.types.addressservice.GetTerminalsResponse;
import com.nortel.soa.oi.cct.types.addressservice.SetDoNotDisturbRequest;
import com.nortel.soa.oi.cct.types.addressservice.SetForwardingRequest;

public class AddressServiceDAO extends ServiceDAO implements IAddressServiceDAO
{	

	private static Logger logger = Logger.getLogger("rc.dao.AddressServiceDAO");
	private String endPoint = null;
    
	public CallResult getConnections(AddressTO addr, String sso) throws DAOException
    {
		String methodName = "getConnections():"; 
		AddressRequest addressRequest = new AddressRequest();
        List<ConnectionTO> connections = new ArrayList<ConnectionTO>();
        GetConnectionsResponse cctConns = null;
	    SsoToken ssoToken = new SsoToken();
	    Address address = new Address();
	    
	    address.setAddressName(addr.getAddressName());
	    address.setAddressType(AddressType.valueOf(addr.getAddressType()));
	    ssoToken.setToken(sso);
	    
	    addressRequest.setAddress(address);
	    addressRequest.setSsoToken(ssoToken);
	    
	    try {        	
	    	cctConns = getPort().getConnections(addressRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    for(Connection cctConn : cctConns.getConnection())
        {
        	ConnectionTO conn = new ConnectionTO();
        	conn.setConnectionId(cctConn.getConnectionId());
        	connections.add(conn);
        }
	    
	    CallResult result = new CallResult();
	    result.setObject(connections);
        return result;
    }
	
	public CallResult getTerminals(AddressTO addr, String sso) throws DAOException
    {
		String methodName = "getTerminals():"; 
		AddressRequest addressRequest = new AddressRequest();
        List<TerminalTO> terminals = new ArrayList<TerminalTO>();
        GetTerminalsResponse cctTerms = null;
	    SsoToken ssoToken = new SsoToken();
	    Address address = new Address();
	    
	    address.setAddressName(addr.getAddressName());
	    address.setAddressType(AddressType.valueOf(addr.getAddressType()));
	    ssoToken.setToken(sso);
	    
	    addressRequest.setAddress(address);
	    addressRequest.setSsoToken(ssoToken);
	    
	    try {        	
	    	cctTerms = getPort().getTerminals(addressRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    for(Terminal cctTerm : cctTerms.getTerminals())
        {
        	TerminalTO term = new TerminalTO();
        	term.setTerminalName(cctTerm.getTerminalName());
        	term.setTerminalType(cctTerm.getTerminalType().value());
        	terminals.add(term);
        }
	    
	    CallResult result = new CallResult();
	    result.setObject(terminals);
        return result;
    }
	
    public CallResult getCapabilities(AddressTO addr, String sso) throws DAOException
    {
    	String methodName = "getCapabilities():"; 
		AddressRequest addressRequest = new AddressRequest();
        AddressCapabilities capabilities = null;
	    SsoToken ssoToken = new SsoToken();
	    Address address = new Address();
	    
	    address.setAddressName(addr.getAddressName());
	    address.setAddressType(AddressType.valueOf(addr.getAddressType()));
	    ssoToken.setToken(sso);
	    
	    addressRequest.setAddress(address);
	    addressRequest.setSsoToken(ssoToken);

	    try {        	
	        capabilities = getPort().getCapabilities(addressRequest).getAddressCapabilities();
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    com.nortel.rc.dto.AddressCapabilitiesTO caps = new com.nortel.rc.dto.AddressCapabilitiesTO();
	    caps.setCanConference(capabilities.isCanConference());
	    caps.setCanDoNotDisturb(capabilities.isCanDoNotDisturb());
	    caps.setCanOriginate(capabilities.isCanOriginate());
	    caps.setCanTransfer(capabilities.isCanTransfer());
	    
	    CallResult result = new CallResult();
	    result.setObject(caps);
        return result;
    }
    
    public CallResult setDoNotDisturb(AddressTO addr, String sso) throws DAOException
    {
    	String methodName = "setDoNotDisturb():"; 
		SetDoNotDisturbRequest request = new SetDoNotDisturbRequest();
	    SsoToken ssoToken = new SsoToken();
	    Address address = new Address();
	    
	    address.setAddressName(addr.getAddressName());
	    address.setAddressType(AddressType.valueOf(addr.getAddressType()));
	    ssoToken.setToken(sso);
	    
	    request.setAddress(address);
	    request.setSsoToken(ssoToken);
	    request.setDoNotDisturb(!addr.isDoNotDisturb());

	    try {        	
	        getPort().setDoNotDisturb(request);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult setForwarding(AddressTO addr, String sso) throws DAOException
    {
    	String methodName = "setForwarding():"; 
		SetForwardingRequest request = new SetForwardingRequest();
	    SsoToken ssoToken = new SsoToken();
	    Address address = new Address();
	    
	    address.setAddressName(addr.getAddressName());
	    address.setAddressType(AddressType.valueOf(addr.getAddressType()));
	    ssoToken.setToken(sso);
	    
	    request.setAddress(address);
	    request.setSsoToken(ssoToken);
	    //request.getForwarding().add(arg0)

	    try {        	
	        getPort().setForwarding(request);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    /**
	 * @return {@link AddressService}
	 * Retrieves interface to be used by service consumers
	 */
	public AddressService getPort() throws DAOException{

		if(endPoint == null){
			SOAOICCTAddressService ss = new SOAOICCTAddressService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
			
		//creating a new binding for each call in case of ha switchover
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(AddressService.class);
		AddressService service = (AddressService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);
					
		return service;
		
	}
}
