package com.nortel.rc.dao;

import com.nortel.rc.dto.AddressCapabilitiesTO;
import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AgentCapabilitiesTO;
import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.AgentTerminalCapabilitiesTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionCapabilitiesTO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactCapabilitiesTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.TerminalCapabilitiesTO;
import com.nortel.rc.dto.TerminalConnectionCapabilitiesTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;

public class CapabilitiesFacade implements ICapabilitiesFacade
{
	private IContactServiceDAO contactServiceDAO;
	private IAddressServiceDAO addressServiceDAO;
	private IAgentServiceDAO agentServiceDAO;
	private IAgentTerminalServiceDAO agentTerminalServiceDAO;
	private ITerminalServiceDAO terminalServiceDAO;
	private ITerminalConnectionServiceDAO terminalConnectionServiceDAO;
	private IConnectionServiceDAO connectionServiceDAO;
	
	public void getCapabilities(TerminalTO terminal, String ssoToken)
	{		
		try
		{
			terminal.setTerminalCapabilities(
					(TerminalCapabilitiesTO)getTerminalServiceDAO().getCapabilities(
							terminal, ssoToken).getObject());
			
			terminal.setAgentTerminalCapabilities(
					(AgentTerminalCapabilitiesTO)getAgentTerminalServiceDAO().getCapabilities(
							terminal, ssoToken).getObject());
			
		}catch(DAOException daoe)
		{
			daoe.printStackTrace();
		}
	}
	
	public void getCapabilities(AddressTO address, String ssoToken)
	{		
		try
		{
			address.setCapabilities(
					(AddressCapabilitiesTO)getAddressServiceDAO().getCapabilities(
							address, ssoToken).getObject());
			
		}catch(DAOException daoe)
		{
			daoe.printStackTrace();
		}
	}	
	
	public void getCapabilities(ContactTO contact, String ssoToken)
	{		
		try
		{
			CallResult cr = getContactServiceDAO().getCapabilities(
					contact.getContactId(), ssoToken); 
			if (cr != null) {
				contact.setCapabilities((ContactCapabilitiesTO)cr.getObject());
			}
			
		}catch(DAOException daoe)
		{
			daoe.printStackTrace();
		}
	}	

	public void getCapabilities(TerminalConnectionTO termConn, String ssoToken)
	{		
		try
		{
			termConn.setCapabilities(
					(TerminalConnectionCapabilitiesTO)getTerminalConnectionServiceDAO().getCapabilities(
							termConn.getTerminalConnectionId(), ssoToken).getObject());
			
		}catch(DAOException daoe)
		{
			daoe.printStackTrace();
		}
	}
	
	public void getCapabilities(ConnectionTO conn, String ssoToken)
	{		
		try
		{
			conn.setCapabilities(
					(ConnectionCapabilitiesTO)getConnectionServiceDAO().getCapabilities(
							conn.getConnectionId(), ssoToken).getObject());
			
		}catch(DAOException daoe)
		{
			daoe.printStackTrace();
		}
	}
	
	public void getCapabilities(AgentTO agent, String ssoToken)
	{		
		try
		{
			agent.setAgentCapabilities(
					(AgentCapabilitiesTO)getAgentServiceDAO().getCapabilities(
							agent, ssoToken).getObject());
			
		}catch(DAOException daoe)
		{
			daoe.printStackTrace();
		}
	}
	
	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}

	/**
	 * @return the addressServiceDAO
	 */
	public IAddressServiceDAO getAddressServiceDAO() {
		return addressServiceDAO;
	}

	/**
	 * @param addressServiceDAO the addressServiceDAO to set
	 */
	public void setAddressServiceDAO(IAddressServiceDAO addressServiceDAO) {
		this.addressServiceDAO = addressServiceDAO;
	}

	/**
	 * @return the agentTerminalServiceDAO
	 */
	public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
		return agentTerminalServiceDAO;
	}

	/**
	 * @param agentTerminalServiceDAO the agentTerminalServiceDAO to set
	 */
	public void setAgentTerminalServiceDAO(
			IAgentTerminalServiceDAO agentTerminalServiceDAO) {
		this.agentTerminalServiceDAO = agentTerminalServiceDAO;
	}

	/**
	 * @return the terminalServiceDAO
	 */
	public ITerminalServiceDAO getTerminalServiceDAO() {
		return terminalServiceDAO;
	}

	/**
	 * @param terminalServiceDAO the terminalServiceDAO to set
	 */
	public void setTerminalServiceDAO(ITerminalServiceDAO terminalServiceDAO) {
		this.terminalServiceDAO = terminalServiceDAO;
	}

	/**
	 * @return the terminalConnectionServiceDAO
	 */
	public ITerminalConnectionServiceDAO getTerminalConnectionServiceDAO() {
		return terminalConnectionServiceDAO;
	}

	/**
	 * @param terminalConnectionServiceDAO the terminalConnectionServiceDAO to set
	 */
	public void setTerminalConnectionServiceDAO(
			ITerminalConnectionServiceDAO terminalConnectionServiceDAO) {
		this.terminalConnectionServiceDAO = terminalConnectionServiceDAO;
	}

	/**
	 * @return the connectionServiceDAO
	 */
	public IConnectionServiceDAO getConnectionServiceDAO() {
		return connectionServiceDAO;
	}

	/**
	 * @param connectionServiceDAO the connectionServiceDAO to set
	 */
	public void setConnectionServiceDAO(IConnectionServiceDAO connectionServiceDAO) {
		this.connectionServiceDAO = connectionServiceDAO;
	}

	/**
	 * @return the agentServiceDAO
	 */
	public IAgentServiceDAO getAgentServiceDAO() {
		return agentServiceDAO;
	}

	/**
	 * @param agentServiceDAO the agentServiceDAO to set
	 */
	public void setAgentServiceDAO(IAgentServiceDAO agentServiceDAO) {
		this.agentServiceDAO = agentServiceDAO;
	}
	
}
