package com.nortel.rc.dao;

import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.exception.DAOException;

public interface IAgentServiceDAO extends IServiceDAO
{
	public CallResult getReadyState(AgentTO agent, String sso) 
			throws DAOException;
	
	public CallResult getNotReadyReasonCode(AgentTO agent, String sso) 
			throws DAOException;
	
	public CallResult getStaticVoiceTerminal(AgentTO agent, String sso) 
			throws DAOException;
	
	public CallResult getSupervisor(AgentTO agent, String sso) 
			throws DAOException;
	
	public CallResult login(AgentTO agentTO, int initialState, String pwd, String sso)	
			throws DAOException;
	
	public CallResult isLoggedIn(AgentTO agent, String sso) 
			throws DAOException;
	
	public CallResult retrieveContact(AgentTO agent, String extContactId, String sso) 
			throws DAOException;
	
	public CallResult getCapabilities(AgentTO agent, String sso) 
			throws DAOException;
	
	public CallResult getContactTypes(AgentTO agentTO, String sso)
			throws DAOException;
}
