package com.nortel.rc.dto;

import java.util.ArrayList;
import java.util.List;
import com.nortel.soa.oi.cct.types.ConnectionState;

public class ConnectionTO {

	private String connectionId;
	private String addressName;
	private String type;
	private String permission;
	private String treatment;
	private StateSummaryTO stateSummary;
	private List<TerminalConnectionTO> terminalConnections = new ArrayList<TerminalConnectionTO>();
	private ConnectionCapabilitiesTO connectionCapabilities;
	/**
	 * @return the connectionId
	 */
	public String getConnectionId() {
		return connectionId;
	}
	/**
	 * @param connectionId the connectionId to set
	 */
	public void setConnectionId(String connectionId) {
		this.connectionId = connectionId;
	}
	/**
	 * @return the addressName
	 */
	public String getAddressName() {
		return addressName;
	}
	/**
	 * @param addressName the addressName to set
	 */
	public void setAddressName(String addressName) {
		this.addressName = addressName;
	}
	/**
	 * @return the connectionCapabilities
	 */
	public ConnectionCapabilitiesTO getCapabilities() {
		return connectionCapabilities;
	}
	/**
	 * @param connectionCapabilities the connectionCapabilities to set
	 */
	public void setCapabilities(
			ConnectionCapabilitiesTO connectionCapabilities) {
		this.connectionCapabilities = connectionCapabilities;
		//Connection capabilities is changed according to the behaviour of SOA RefClient and the .NET RefClient is as close as possible
		if(this.getStateSummary() != null && ConnectionState.ALERTING.toString().equals(this.getStateSummary().getCurrent())) {
			this.connectionCapabilities.setCanDisconnect(false);
		}
	}
	
	/**
	 * @return the terminalConnections
	 */
	public TerminalConnectionTO getTerminalConnection(String id) {
		TerminalConnectionTO termConn = null;
		for(TerminalConnectionTO tcTO : terminalConnections)
		{
			if(tcTO.getTerminalConnectionId().equals(id))
			{
				termConn = tcTO;
				break;
			}
		}
		return termConn;
	}
	/**
	 * @return the terminalConnections
	 */
	public List<TerminalConnectionTO> getTerminalConnections() {
		return terminalConnections;
	}
	
	public void addTerminalConnection(TerminalConnectionTO terminalConnection) {
		this.terminalConnections.add(terminalConnection);
	}
	
	/**
	 * @param terminalConnections the terminalConnections to set
	 */
	public void setTerminalConnections(
			List<TerminalConnectionTO> terminalConnections) {
		this.terminalConnections = terminalConnections;
	}
	/**
	 * @return the type
	 */
	public String getType() {
		return type;
	}
	/**
	 * @param type the type to set
	 */
	public void setType(String type) {
		this.type = type;
	}	
	/**
	 * @return the permission
	 */
	public String getPermission() {
		return permission;
	}
	/**
	 * @param permission the permission to set
	 */
	public void setPermission(String permission) {
		this.permission = permission;
	}
	/**
	 * @return the treatment
	 */
	public String getTreatment() {
		return treatment;
	}
	/**
	 * @param treatment the treatment to set
	 */
	public void setTreatment(String treatment) {
		this.treatment = treatment;
	}
	/**
	 * @return the stateSummary
	 */
	public StateSummaryTO getStateSummary() {
		return stateSummary;
	}
	/**
	 * @param stateSummary the stateSummary to set
	 */
	public void setStateSummary(StateSummaryTO stateSummary) {
		this.stateSummary = stateSummary;
	}	
}
