package com.nortel.rc.dto;

import java.util.ArrayList;
import java.util.List;

public class TerminalTO {
	
	private String terminalName;
	private String terminalType;
	private String loginId = "";
	private ProviderTO provider;
	private String terminalStatus;
	private String terminalNotReadyReason;
	private String terminalActivityCode;
	private boolean doNotDisturb = false;
	private List<ForwardInstructionTO> forwardInstructions = new ArrayList<ForwardInstructionTO>();
	private boolean forwarding = false;
	private boolean agentLoggedIn = false;
	private boolean terminalReady = false;
	private boolean activityCode = false;
	private boolean outOfService = false;
	private List<AddressTO> addresses = new ArrayList<AddressTO>();
	private List<String> contactTypes = new ArrayList<String>();
	private TerminalCapabilitiesTO terminalCapabilities;
	private AgentTerminalCapabilitiesTO agentTerminalCapabilities;

	/**
	 * @return the terminalName
	 */
	public String getTerminalName() {
		return terminalName;
	}

	/**
	 * @param terminalName the terminalName to set
	 */
	public void setTerminalName(String terminalName) {
		this.terminalName = terminalName;
	}

	/**
	 * @return the terminalCapabilities
	 */
	public TerminalCapabilitiesTO getTerminalCapabilities() {
		return terminalCapabilities;
	}

	/**
	 * @param terminalCapabilities the terminalCapabilities to set
	 */
	public void setTerminalCapabilities(TerminalCapabilitiesTO terminalCapabilities) {
		this.terminalCapabilities = terminalCapabilities;
	}

	/**
	 * @return the agentTerminalCapabilities
	 */
	public AgentTerminalCapabilitiesTO getAgentTerminalCapabilities() {
		return agentTerminalCapabilities;
	}

	/**
	 * @param agentTerminalCapabilities the agentTerminalCapabilities to set
	 */
	public void setAgentTerminalCapabilities(
			AgentTerminalCapabilitiesTO agentTerminalCapabilities) {
		this.agentTerminalCapabilities = agentTerminalCapabilities;
	}

	/**
	 * @return the addresses
	 */
	public List<AddressTO> getAddresses() {
		return addresses;
	}

	/**
	 * @param addresses the addresses to set
	 */
	public void setAddresses(List<AddressTO> addresses) {
		this.addresses = addresses;
	}
	
	/**
	 * @param addresses the addresses to add
	 */
	public void addAddress(AddressTO newAddress)
	{
		addresses.add(newAddress);
	}

	/**
	 * @return the terminalType
	 */
	public String getTerminalType() {
		return terminalType;
	}

	/**
	 * @param terminalType the terminalType to set
	 */
	public void setTerminalType(String terminalType) {
		this.terminalType = terminalType;
	}
	
	public AddressTO getAddress(String addressName)
	{
		for(AddressTO address : addresses)
		{
			if(address.getAddressName().equals(addressName))
			{
				return address;
			}
		}
		return null;
	}

	/**
	 * @return the terminalStatus
	 */
	public String getTerminalStatus() {
		return terminalStatus;
	}

	/**
	 * @param terminalStatus the terminalStatus to set
	 */
	public void setTerminalStatus(String terminalStatus) {
		this.terminalStatus = terminalStatus;
	}

	/**
	 * @return the doNotDisturb
	 */
	public boolean isDoNotDisturb() {
		return doNotDisturb;
	}

	/**
	 * @param doNotDisturb the doNotDisturb to set
	 */
	public void setDoNotDisturb(boolean doNotDisturb) {
		this.doNotDisturb = doNotDisturb;
	}

	/**
	 * @return the agentLoggedIn
	 */
	public boolean isAgentLoggedIn() {
		return agentLoggedIn;
	}

	/**
	 * @param agentLoggedIn the agentLoggedIn to set
	 */
	public void setAgentLoggedIn(boolean agentLoggedIn) {
		this.agentLoggedIn = agentLoggedIn;
		this.activityCode = agentLoggedIn;
	}

	/**
	 * @return the activityCode
	 */
	public boolean isActivityCode() {
		return activityCode;
	}

	/**
	 * @return the terminalReady
	 */
	public boolean isTerminalReady() {
		return terminalReady;
	}

	/**
	 * @param terminalReady the terminalReady to set
	 */
	public void setTerminalReady(boolean terminalReady) {
		this.terminalReady = terminalReady;
	}

	/**
	 * @return the terminalNotReadyReason
	 */
	public String getTerminalNotReadyReason() {
		return terminalNotReadyReason;
	}

	/**
	 * @param terminalNotReadyReason the terminalNotReadyReason to set
	 */
	public void setTerminalNotReadyReason(String terminalNotReadyReason) {
		this.terminalNotReadyReason = terminalNotReadyReason;
	}

	/**
	 * @return the terminalActivityCode
	 */
	public String getTerminalActivityCode() {
		return terminalActivityCode;
	}

	/**
	 * @param terminalActivityCode the terminalActivityCode to set
	 */
	public void setTerminalActivityCode(String terminalActivityCode) {
		this.terminalActivityCode = terminalActivityCode;
	}

	/**
	 * @return the forwardInstruction
	 */
	public List<ForwardInstructionTO> getForwardInstruction() {
		return forwardInstructions;
	}

	/**
	 * @param forwardInstruction the forwardInstruction to set
	 */
	public void setForwardInstruction(List<ForwardInstructionTO> forwardInstructions) {
		this.forwardInstructions = forwardInstructions;
	}

	/**
	 * @return the forwarding
	 */
	public boolean isForwarding() {
		return forwarding;
	}

	/**
	 * @param forwarding the forwarding to set
	 */
	public void setForwarding(boolean forwarding) {
		this.forwarding = forwarding;
	}

	/**
	 * @return the contactTypes
	 */
	public List<String> getContactTypes() {
		return contactTypes;
	}

	/**
	 * @param contactTypes the contactTypes to set
	 */
	public void setContactTypes(List<String> contactTypes) {
		this.contactTypes = contactTypes;
	}

	/**
	 * @return the provider
	 */
	public ProviderTO getProvider() {
		return provider;
	}

	/**
	 * @param provider the provider to set
	 */
	public void setProvider(ProviderTO provider) {
		this.provider = provider;
	}

	/**
	 * @return the outOfService
	 */
	public boolean isOutOfService() {
		return outOfService;
	}

	/**
	 * @param outOfService the outOfService to set
	 */
	public void setOutOfService(boolean outOfService) {
		this.outOfService = outOfService;
	}

	/**
	 * @return the loginId
	 */
	public String getLoginId() {
		return loginId;
	}

	/**
	 * @param loginId the loginId to set
	 */
	public void setLoginId(String loginId) {
		this.loginId = loginId;
	}
}
