package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IAgentTerminalServiceDAO;
import com.nortel.rc.dto.TerminalTO;

public class GetActivityCodeCommand extends Command 
{
	private IAgentTerminalServiceDAO agentTerminalServiceDAO;
	private String activityCode;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		TerminalTO terminal = (TerminalTO)params.get("terminal");
		
		activityCode = getAgentTerminalServiceDAO().getActivityCode(terminal, ssoToken).getMessage();
	
		getRefClient().updateActivityCode(activityCode);
	}

	/**
	 * @return the agentTerminalServiceDAO
	 */
	public IAgentTerminalServiceDAO getAgentTerminalServiceDAO() {
		return agentTerminalServiceDAO;
	}

	/**
	 * @param agentTerminalServiceDAO the agentTerminalServiceDAO to set
	 */
	public void setAgentTerminalServiceDAO(
			IAgentTerminalServiceDAO agentTerminalServiceDAO) {
		this.agentTerminalServiceDAO = agentTerminalServiceDAO;
	}	
}
