package com.nortel.rc.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Scanner;

import org.springframework.core.io.ClassPathResource;

public class SetServerDetailsCommand extends Command 
{
	private String securityConfig;
	private String endpointFilename;
	private String serverPort = null;
	private String newServerPort = null;	
	
	public void execute(Map<String, Object> params) throws Exception
	{
		String oldProtocol = (String)params.get("protocol");
		String newProtocol = (String)params.get("newProtocol");
		serverPort = oldProtocol+"://"+(String)params.get("server")+":"+(String)params.get("port");
		newServerPort = newProtocol+"://"+(String)params.get("newServer")+":"+(String)params.get("newPort");
		boolean endpointUpdateSuccess = false;
		
		if(!serverPort.equalsIgnoreCase(newServerPort))
		{
			FileWriter writer = null;
			try
			{				
				ClassPathResource res = new ClassPathResource(getEndpointFilename());
				File file = new File(res.getURL().toURI());
				writer = new FileWriter(file);
				writer.write(newServerPort);
				endpointUpdateSuccess = true;
			}
			catch(IOException ioex)
			{
				//Roll back wsdl changes and report error
				undoEndpointUpdate();
				throw new Exception("Problem updating endpoint "+ioex.getMessage());
			} catch (URISyntaxException uex) {
				//Roll back wsdl changes and report error
				undoEndpointUpdate();
				throw new Exception("Problem updating endpoint "+uex.getMessage());
			}			
			finally
			{
				if (writer != null){
					try {
						writer.close();
					} catch (IOException e) {
					}
				}
				
			}
					
			//Now update what CXF Configuration to use (http/https)
			if(endpointUpdateSuccess && !newProtocol.equalsIgnoreCase(oldProtocol))
			{
				try
				{
					System.out.println("Updating Security Config");
					ClassPathResource res = new ClassPathResource(getSecurityConfig());
					String uriString = res.getURL().toURI().toString();
					File currentFile = new File(new URI(uriString));
					
					if(newProtocol.equalsIgnoreCase("https"))
					{
						res = new ClassPathResource(getSecurityConfig()+"_https");
						File httpsFile = new File(res.getURL().toURI());
						
						//Rename current file in use to <NAME>_http
						File newName = new File(new URI(uriString+"_http"));
						if(newName.exists())
							newName.delete();
						if (!currentFile.renameTo(newName) )
							throw new IOException("Error renaming current file in use to <NAME>_http");
						//Rename https file to (getSecurityConfig())
						newName = new File(new URI(uriString));
						if(newName.exists())
							newName.delete();
						if (!httpsFile.renameTo(newName))
							throw new IOException("Error renaming https file to "+getSecurityConfig());
					}
					else
					{
						res = new ClassPathResource(getSecurityConfig()+"_http");
						File httpFile = new File(res.getURL().toURI());
						
						//Rename current file in use to <NAME>_https
						File newName = new File(new URI(uriString+"_https"));
						if(newName.exists())
							newName.delete();
						if (!currentFile.renameTo(newName) )
							throw new IOException("Error renaming current file in use to <NAME>_https");
						//Rename http file to (getSecurityConfig())
						newName = new File(new URI(uriString));
						if(newName.exists())
							newName.delete();
						if (!httpFile.renameTo(newName))
							throw new IOException("Error renaming http file to "+getSecurityConfig());
					}
					getRefClient().promptForRestart();
				}
				catch(IOException ioex)
				{
					undoEndpointUpdate();
					throw new Exception("Problem changing "+getSecurityConfig()+" to use "+newProtocol+" version:"+ioex.getMessage());
				} 
				catch (URISyntaxException uex) 
				{
					undoEndpointUpdate();
					throw new Exception("Problem changing "+getSecurityConfig()+" to use "+newProtocol+" version:"+uex.getMessage());
				}
			}
			else if(endpointUpdateSuccess && newProtocol.equalsIgnoreCase(oldProtocol))
			{
				getRefClient().promptForRestart();
			}
		}
	}
	
	private void updateFile(File file, File newFile, String exp, String serverPort, String newServerPort) throws Exception
	{
		FileWriter writer = null;
		Scanner scanner = null;
		try {
			writer = new FileWriter(newFile);
			
			//Create the scanner using the file - to be searched by line
			scanner = new Scanner(file);
			scanner.useDelimiter(System.getProperty("line.separator"));
			
			String targetLine = null;
			String match = null;
			while (scanner.hasNext())
			{
				//When we find the line - end loop
				targetLine = scanner.next();				 
				Scanner lineScanner = new Scanner(targetLine);
				match = lineScanner.findInLine(exp);
				if(match != null)
				{
					targetLine = targetLine.replaceFirst(serverPort, newServerPort);
				}
				writer.write(targetLine+System.getProperty("line.separator"));
				lineScanner.close();					
			}
			match = null;
		
		} finally{
			if (writer != null){
				try {
					writer.close();
				} catch (IOException e) {
				}
			}
			if (scanner != null){
				scanner.close();
			}
		}
	}
	
	private void undoEndpointUpdate() throws Exception
	{
		try
		{
			ClassPathResource res = new ClassPathResource(getEndpointFilename());
			String uriString = res.getURL().toURI().toString();
			File file = new File(new URI(uriString));
			
			File newFile = new File(new URI(uriString+".new"));
			updateFile(file, newFile, newServerPort, newServerPort, serverPort);
			
			if(file.delete())
			{
				if (!newFile.renameTo(new File(new URI(uriString))))
					throw new IOException("Error renaming file "+newFile.getName());
			}

		}
		catch(Exception e)
		{
			throw new Exception("Problem updating endpoint",e);
		}
	}

	/**
	 * @return the securityConfig
	 */
	public String getSecurityConfig() {
		return securityConfig;
	}

	/**
	 * @param securityConfig the securityConfig to set
	 */
	public void setSecurityConfig(String securityConfig) {
		this.securityConfig = securityConfig;
	}

	/**
	 * @return the endpointFilename
	 */
	public String getEndpointFilename() {
		return endpointFilename;
	}

	/**
	 * @param endpointFilename the endpointFilename to set
	 */
	public void setEndpointFilename(String endpointFilename) {
		this.endpointFilename = endpointFilename;
	}
}