package com.nortel.rc.dao;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalConnectionTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.connectionservice.ConnectionService;
import com.nortel.soa.oi.cct.connectionservice.SOAOICCTConnectionService;
import com.nortel.soa.oi.cct.sessionservice.SessionService;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.ConnectionCapabilities;
import com.nortel.soa.oi.cct.types.ConnectionStateInfo;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.TerminalConnection;
import com.nortel.soa.oi.cct.types.connectionservice.AddressResponse;
import com.nortel.soa.oi.cct.types.connectionservice.ConnectionRequest;
import com.nortel.soa.oi.cct.types.connectionservice.ConnectionStateResponse;
import com.nortel.soa.oi.cct.types.connectionservice.ContactResponse;
import com.nortel.soa.oi.cct.types.connectionservice.TerminalConnectionsResponse;

public class ConnectionServiceDAO extends ServiceDAO implements IConnectionServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.ConnectionServiceDAO");
	private String endPoint = null;
    
    public CallResult getCapabilities(String connectionId, String sso) throws DAOException
    {
    	String methodName = "getCapabilities():";
		ConnectionRequest connectionRequest = new ConnectionRequest();
        ConnectionCapabilities capabilities = null;
	    SsoToken ssoToken = new SsoToken();
	    Connection connection = new Connection();
	    
	    connection.setConnectionId(connectionId);
	    ssoToken.setToken(sso);
	    
	    connectionRequest.setConnection(connection);
	    connectionRequest.setSsoToken(ssoToken);

	    try 
	    {        	
	        capabilities = getPort().getConnectionCapabilities(connectionRequest).getConnectionCapabilities();
	    }
	    catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    com.nortel.rc.dto.ConnectionCapabilitiesTO caps = new com.nortel.rc.dto.ConnectionCapabilitiesTO();
	    caps.setCanAccept(capabilities.isCanAccept());
	    caps.setCanDisconnect(capabilities.isCanDisconnect());
	    caps.setCanAlert(capabilities.isCanAlert());
		caps.setCanPark(capabilities.isCanPark());
		caps.setCanRedirect(capabilities.isCanRedirect());
		caps.setCanReject(capabilities.isCanReject());
	    
	    CallResult result = new CallResult();
	    result.setObject(caps);
        return result;
    }
    
    public CallResult getContact(String connectionId, String sso) throws DAOException
    {
    	String methodName = "getContact():";
		ConnectionRequest connectionRequest = new ConnectionRequest();
        ContactResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    Connection connection = new Connection();
	    
	    connection.setConnectionId(connectionId);
	    ssoToken.setToken(sso);
	    
	    connectionRequest.setConnection(connection);
	    connectionRequest.setSsoToken(ssoToken);

	    try 
	    {        	
	        response = getPort().getContact(connectionRequest);
	    }
	    catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    ContactTO contact = new ContactTO();
	    if(response != null)
	    {
	    	contact.setContactId(response.getContact().getContactId());
	    	contact.setExternalContactId(response.getContact().getExternalContactId());
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(contact);
        return result;
    }
    
    public CallResult getAddress(String connectionId, String sso) throws DAOException
    {
    	String methodName = "getAddress():";
		ConnectionRequest connectionRequest = new ConnectionRequest();
        AddressResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    Connection connection = new Connection();
	    
	    connection.setConnectionId(connectionId);
	    ssoToken.setToken(sso);
	    
	    connectionRequest.setConnection(connection);
	    connectionRequest.setSsoToken(ssoToken);

	    try 
	    {        	
	        response = getPort().getAddress(connectionRequest);
	    }
	    catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    AddressTO address = new AddressTO();
	    if(response != null)
	    {
	    	address.setAddressName(response.getAddress().getAddressName());
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(address);
        return result;
    }
    
    public CallResult getTerminalConnections(String connectionId, String sso) throws DAOException
    {
    	String methodName = "getTerminalConnections():";
		ConnectionRequest connectionRequest = new ConnectionRequest();
        TerminalConnectionsResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    Connection connection = new Connection();
	    
	    connection.setConnectionId(connectionId);
	    ssoToken.setToken(sso);
	    
	    connectionRequest.setConnection(connection);
	    connectionRequest.setSsoToken(ssoToken);

	    try 
	    {        	
	        response = getPort().getTerminalConnections(connectionRequest);
	    }
	    catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    List<TerminalConnectionTO> terminalConnections = new ArrayList<TerminalConnectionTO>();
	    if(response != null)
	    {
		    for(TerminalConnection cctTermConn : response.getTerminalConnections())
	        {
	        	TerminalConnectionTO termConn = new TerminalConnectionTO();
	        	termConn.setTerminalConnectionId(cctTermConn.getTerminalConnectionId());
	        	terminalConnections.add(termConn);
	        }
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(terminalConnections);
        return result;
    }
    
    public CallResult getState(String connectionId, String sso) throws DAOException
    {
    	String methodName = "getState():";
		ConnectionRequest connectionRequest = new ConnectionRequest();
//        StateResponse response = null;
        ConnectionStateResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    Connection connection = new Connection();
	    
	    connection.setConnectionId(connectionId);
	    ssoToken.setToken(sso);
	    
	    connectionRequest.setConnection(connection);
	    connectionRequest.setSsoToken(ssoToken);

	    try 
	    {        	
	        response = getPort().getState(connectionRequest);
	    }
	    catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    if(response != null)
	    {	    
		    StateSummaryTO stateSummary = new StateSummaryTO();
		    ConnectionStateInfo stateInfo = response.getConnectionStateInfo();
		    //Eoinmc, added enum for state, reason
//		    stateSummary.setCurrent(response.getStateInfo().getCurrentState().getState());
//		    stateSummary.setPrevious(response.getStateInfo().getLastState().getState());
//		    stateSummary.setReason(response.getStateInfo().getCurrentState().getReasonCode());
		    if(stateInfo != null)
		    {
		    	if(stateInfo.getCurrentState() != null)
		    	{
				    stateSummary.setCurrent(stateInfo.getCurrentState().getState().toString());
				    if(stateInfo.getCurrentState().getReasonCode() != null)
				    {
				    	stateSummary.setReason(stateInfo.getCurrentState().getReasonCode().toString());
				    }
		    	}
		    	if(stateInfo.getLastState() != null && stateInfo.getLastState().getState() != null)
		    	{
		    		stateSummary.setPrevious(stateInfo.getLastState().getState().toString());
		    	}
			    result.setObject(stateSummary);
		    }
	    }
        return result;
    }
    
    public CallResult disconnect(String connectionId, String sso) throws DAOException
    {
    	String methodName = "disconnect():";
		ConnectionRequest connectionRequest = new ConnectionRequest();
	    SsoToken ssoToken = new SsoToken();
	    Connection connection = new Connection();
	    
	    connection.setConnectionId(connectionId);
	    ssoToken.setToken(sso);
	    
	    connectionRequest.setConnection(connection);
	    connectionRequest.setSsoToken(ssoToken);

	    try 
	    {        	
	        getPort().disconnect(connectionRequest);
	    }
	    catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();

        return result;
    }
    
    /**
	 * @return {@link SessionService}
	 * Retrieves interface to be used by service consumers
	 */
	public ConnectionService getPort() throws DAOException{
		if(endPoint == null)
		{				
			SOAOICCTConnectionService ss = new SOAOICCTConnectionService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
			JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
			factory.setServiceClass(ConnectionService.class);
			ConnectionService service = (ConnectionService) factory.create();
			((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);
					
			return service;
	}

	@Override
	public CallResult alert(String connectionId, String sso) throws DAOException {
		String methodName = "alert():";
		ConnectionRequest connectionRequest = new ConnectionRequest();
	    SsoToken ssoToken = new SsoToken();
	    Connection connection = new Connection();
	    
	    connection.setConnectionId(connectionId);
	    ssoToken.setToken(sso);
	    
	    connectionRequest.setConnection(connection);
	    connectionRequest.setSsoToken(ssoToken);

	    try 
	    {        	
	        getPort().alert(connectionRequest);
	    }
	    catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();

        return result;
	}
}
