package com.nortel.rc.dao;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.core.io.ClassPathResource;

import com.nortel.rc.exception.DAOException;

public class ServiceDAO
{
	private QName serviceQName;
	private String endpointFilename;
	private String serverDetails;
	private String serviceUrl;
	
	public ServiceDAO()
	{
		ClassPathResource res = new ClassPathResource("endpoint.txt");
		BufferedReader reader = null;
		try {
			InputStreamReader streamReader = new InputStreamReader(new FileInputStream(res.getFile()));
			reader = new BufferedReader(streamReader);
			serverDetails = String.valueOf(reader.readLine()).trim();			
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}finally{
			if (reader != null) {
				try {
					reader.close();
				} catch (IOException e) {				
				}
			}	
		}
	}
	
	public URL getWsdlUrl() throws DAOException
	{
		URL url = null;
		try {
			url = new URL(getServerDetails()+getServiceUrl());
		} catch (MalformedURLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("Getting wsdlUrl for service call: "+getServerDetails()+getServiceUrl());
		return url;
	}

	/**
	 * @return the serviceQName
	 */
	public QName getServiceQName() {
		return serviceQName;
	}

	/**
	 * @param serviceQName the serviceQName to set
	 */
	public void setServiceQName(QName serviceQName) {
		this.serviceQName = serviceQName;
	}

	/**
	 * @return the serviceUrl
	 */
	public String getServiceUrl() {
		return serviceUrl;
	}

	/**
	 * @param serviceUrl the serviceUrl to set
	 */
	public void setServiceUrl(String serviceUrl) {
		this.serviceUrl = serviceUrl;
	}

	/**
	 * @return the serverDetails
	 */
	public String getServerDetails() {
		return serverDetails;
	}

	/**
	 * @param serverDetails the serverDetails to set
	 */
	public void setServerDetails(String serverDetails) {
		this.serverDetails = serverDetails;
	}

	/**
	 * @return the endpointFilename
	 */
	public String getEndpointFilename() {
		return endpointFilename;
	}

	/**
	 * @param endpointFilename the endpointFilename to set
	 */
	public void setEndpointFilename(String endpointFilename) {
		this.endpointFilename = endpointFilename;
	}
	
	public void logExecption(Logger logger, String methodName, Exception e) {
		StackTraceElement[] stack = e.getStackTrace();
		StringBuilder strb = new StringBuilder(methodName);
		strb.append(e.getCause());strb.append("\n");
		strb.append(e.getMessage());strb.append("\n");
		for(StackTraceElement s: stack){
			strb.append(s.toString());strb.append("\n");
		}
		logger.log(Level.ERROR, strb.toString());
		
	}
	
	
}