package sample.consumer;

import java.util.List;


import com.nortel.soa.oi.cct.basenotification.NotificationEventHolderType;
import com.nortel.soa.oi.cct.basenotification.NotificationMessageHolderType;
import com.nortel.soa.oi.cct.notification.SystemEventType;
import com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.userservice.SessionHeartbeatAndHACheckRequest;
import com.nortel.soa.oi.cct.types.userservice.SessionHeartbeatAndHACheckResponse;
import com.nortel.soa.oi.cct.userservice.UserService;

@javax.jws.WebService(name = "NotificationConsumer",
	    serviceName = "SOAOICCT_NotificationConsumer",
	    portName = "NotificationConsumer",
	    targetNamespace = "http://www.nortel.com/soa/oi/cct/NotificationConsumer",
	    endpointInterface = "com.nortel.soa.oi.cct.notificationconsumer.NotificationConsumer")
public class ConsumerImpl implements NotificationConsumer {
	
	private UserService userService;
	private SsoToken ssoToken;
	
	
	public ConsumerImpl (SsoToken ssoToken, UserService userService){
		this.ssoToken = ssoToken;
		this.userService = userService;
	}

	@Override
	public void notify(List<NotificationMessageHolderType> notificationMessage) {
	        try {
	            for(NotificationMessageHolderType nmh : notificationMessage) {
	                NotificationEventHolderType notificationEventHolder = nmh.getMessage();
	                System.out.println("CONSUMER..." + notificationEventHolder.getEventType().name());              
	                switch (notificationEventHolder.getEventType()) {
	                    case SYSTEM:
	                    	//handle System notification here
	                    	processSystemEvent(notificationEventHolder.getSystemEvent());
	                        break;
	                        
	                    default:
	        				System.out.println( "Event is not handled");
	        				break;
	                }
	             }
	       
	        } catch (Exception ex) {
	            ex.printStackTrace();
	            throw new RuntimeException(ex);
	        }
		
		
		
	}
	
	private void processSystemEvent(final SystemEventType systemEvent) throws Exception
	{
		System.out.println("System Event: " + systemEvent.getSystemEvent().value());

		switch (systemEvent.getSystemEvent())
		{
			case SESSION_TERMINATION:
				System.out.println( "SESSION_TERMINATION Reason: "+ systemEvent.getSystemEventSessionTermination().getInfo());
				break;
			
			case SESSION_TERMINATION_IMMINENT:
				System.out.println(  "SESSION_TERMINATION_IMMINENT");
				SessionHeartbeatAndHACheckRequest request = new SessionHeartbeatAndHACheckRequest();
				request.setSsoToken(ssoToken);
				try
				{
					SessionHeartbeatAndHACheckResponse response = userService.sessionHeartbeatAndHACheck(request);
					
					if(response != null) {
						System.out.println( "Response session update["+ response.isSessionUpdated()+"]");
					} else
						throw new Exception("StartHASwitchEventListenerResponse cannot be NULL");
					
		        } catch (Exception e) {
		        	e.printStackTrace();     
		        }	
				break;
		
			case CONNECTION_FAILURE:
				System.out.println( "CONNECTION_FAILURE");
				break;

			default:
				System.out.println( "System Event: " + systemEvent.getSystemEvent().value() + " is unrecognized");
				break;
		}
	}

}
