package sample.run;

import org.xmlsoap.schemas.ws._2003._03.addressing.EndpointReferenceType;

import com.nortel.soa.oi.cct.types.SsoToken;

import sample.subscribe.NotificationProducerSubscribe;
import sample.subscribe.UserImpl;

public class TestSessionTermination {

	public static void main(String[] args) throws Exception {
		
		String userName = "user";
		String password = "password";
		String domain = "localhost";
		String cctServiceHostAndPort = "server1:9080";
		String consumerPort = "9090";
		String consumerPort2 = "9078";
		 
		//User Input
		if (args!= null && args.length == 6) {
			userName = args[0];
			password = args[1];
			domain = args[2];
			cctServiceHostAndPort = args[3];
			consumerPort = args[4];
			consumerPort2 = args[5];
		}
		
		
		//Simple subscribe for all events via user service
		UserImpl us = new UserImpl(consumerPort, cctServiceHostAndPort);

		//Login to get SSO TOKENT
		SsoToken ssoToken = us.loginToCctServer(userName, password, domain);
		
		//Subscribe for Agent Property Notifications via notification producer
		NotificationProducerSubscribe nps = new NotificationProducerSubscribe(consumerPort2, cctServiceHostAndPort, ssoToken);
		String consumerEndpoint = nps.publishNotificationConsumer();
		EndpointReferenceType subscription2 = nps.subscribe(consumerEndpoint, ssoToken);
		 
		//Sleep for 5 minutes so we can listen for session timeout events
		Thread.sleep(300000);
		
		//Unsubsribe
		nps.unsubscribe(subscription2, ssoToken);
		
		//Sleep to ensure notifications done
		Thread.sleep(1000);
		
		//Logout
		us.logout(ssoToken);
		
		
	}
}
