package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IRoutePointAddressServiceDAO;
import com.nortel.rc.dto.AddressTO;

public class ControlRoutePointCommand extends Command 
{
	private IRoutePointAddressServiceDAO routePointAddressServiceDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		AddressTO address = (AddressTO)params.get("address");
		getRoutePointAddressServiceDAO().control(address, ssoToken);
	}

	/**
	 * @return the routePointAddressServiceDAO
	 */
	public IRoutePointAddressServiceDAO getRoutePointAddressServiceDAO() {
		return routePointAddressServiceDAO;
	}

	/**
	 * @param routePointAddressServiceDAO the routePointAddressServiceDAO to set
	 */
	public void setRoutePointAddressServiceDAO(
			IRoutePointAddressServiceDAO routePointAddressServiceDAO) {
		this.routePointAddressServiceDAO = routePointAddressServiceDAO;
	}
}
