package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.ICapabilitiesFacade;
import com.nortel.rc.dao.IConnectionServiceDAO;
import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.TerminalConnectionTO;

public class GetContactCapabilitiesCommand extends Command 
{
	private ICapabilitiesFacade capabilitiesFacade;
	private IContactServiceDAO contactServiceDAO;
	private IConnectionServiceDAO connectionServiceDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		String contactId = (String)params.get("contactId");
		ContactTO contact = new ContactTO();		
		
		contact.setContactId(contactId);
		getCapabilitiesFacade().getCapabilities(contact, ssoToken);
		
		List<ConnectionTO> connections = (List<ConnectionTO>)getContactServiceDAO().getConnections(contactId, ssoToken).getObject();
		for(ConnectionTO connection : connections)
		{
			getCapabilitiesFacade().getCapabilities(connection, ssoToken);
			
			List<TerminalConnectionTO> terminalConnections = (List<TerminalConnectionTO>)getConnectionServiceDAO().getTerminalConnections(connection.getConnectionId(), ssoToken).getObject();
			for(TerminalConnectionTO termConn : terminalConnections)
			{
				getCapabilitiesFacade().getCapabilities(termConn, ssoToken);
				connection.addTerminalConnection(termConn);
			}
			contact.addConnection(connection);
		}				
	
		getRefClient().updateCurrentContactCapabilities(contact);		
	}
	
	/**
	 * @return the capabilitiesFacade
	 */
	public ICapabilitiesFacade getCapabilitiesFacade() {
		return capabilitiesFacade;
	}

	/**
	 * @param capabilitiesFacade the capabilitiesFacade to set
	 */
	public void setCapabilitiesFacade(ICapabilitiesFacade capabilitiesFacade) {
		this.capabilitiesFacade = capabilitiesFacade;
	}

	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}

	/**
	 * @return the connectionServiceDAO
	 */
	public IConnectionServiceDAO getConnectionServiceDAO() {
		return connectionServiceDAO;
	}

	/**
	 * @param connectionServiceDAO the connectionServiceDAO to set
	 */
	public void setConnectionServiceDAO(IConnectionServiceDAO connectionServiceDAO) {
		this.connectionServiceDAO = connectionServiceDAO;
	}
}
