package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IContactServiceDAO;
import com.nortel.rc.dto.IntrinsicTO;

public class GetIntrinsicDataCommand extends Command 
{
	private IContactServiceDAO contactServiceDAO;
	private List<IntrinsicTO> data;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		String contactId = (String)params.get("contactId");
		data = (List<IntrinsicTO>)getContactServiceDAO().getIntrinsicData(contactId, ssoToken).getObject();
		getRefClient().updateIntrinsicData(contactId, data);
	}	
	
	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}
}
