package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.IContactDAO;
import com.nortel.rc.dto.IntrinsicTO;

public class GetIntrinsicDataSessionServiceCommand extends Command 
{
	private IContactDAO contactDAO;
	private List<IntrinsicTO> data;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		String contactId = (String)params.get("contactId");
		data = (List<IntrinsicTO>)getContactDAO().getIntrinsicData(contactId, ssoToken).getObject();
		getRefClient().updateIntrinsicData(contactId, data);
	}	
	
	/**
	 * @return the contactDAO
	 */
	public IContactDAO getContactDAO() {
		return contactDAO;
	}

	/**
	 * @param contactDAO the contactDAO to set
	 */
	public void setContactDAO(IContactDAO contactDAO) {
		this.contactDAO = contactDAO;
	}
}
