package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IContactServiceDAO;

public class GetUUIDataCommand extends Command 
{
	private IContactServiceDAO contactServiceDAO;
	private String data;
	
	public void execute(Map<String, Object> params) throws Exception
	{
		String contactId = (String)params.get("contactId");
		data = getContactServiceDAO().getUUIData(contactId, ssoToken).getMessage();
		getRefClient().updateUUIData(contactId, data);
	}	
	
	/**
	 * @return the contactServiceDAO
	 */
	public IContactServiceDAO getContactServiceDAO() {
		return contactServiceDAO;
	}

	/**
	 * @param contactServiceDAO the contactServiceDAO to set
	 */
	public void setContactServiceDAO(IContactServiceDAO contactServiceDAO) {
		this.contactServiceDAO = contactServiceDAO;
	}
}
