package com.nortel.rc.command;

import java.util.Map;

import com.nortel.rc.dao.IRoutePointConnectionServiceDAO;
import com.nortel.rc.dto.ConnectionTO;

public class GiveMediaTreatmentCommand extends Command 
{
private IRoutePointConnectionServiceDAO routePointConnectionServiceDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		String treatmentTerminal = (String)params.get("treatmentTerminal");
		String treatmentAddress = (String)params.get("treatmentAddress");
		ConnectionTO connection = (ConnectionTO)params.get("connection");
		String type = (String)params.get("type"); 
		getRoutePointConnectionServiceDAO().giveMediaTreatment(treatmentTerminal, treatmentAddress, connection, type, ssoToken);
	}

	/**
	 * @return the routePointConnectionServiceDAO
	 */
	public IRoutePointConnectionServiceDAO getRoutePointConnectionServiceDAO() {
		return routePointConnectionServiceDAO;
	}

	/**
	 * @param routePointConnectionServiceDAO the routePointConnectionServiceDAO to set
	 */
	public void setRoutePointConnectionServiceDAO(
			IRoutePointConnectionServiceDAO routePointConnectionServiceDAO) {
		this.routePointConnectionServiceDAO = routePointConnectionServiceDAO;
	}
}
