package com.nortel.rc.command;

import java.util.List;
import java.util.Map;

import com.nortel.rc.dao.ITerminalServiceDAO;
import com.nortel.rc.dto.ForwardInstructionTO;
import com.nortel.rc.dto.TerminalTO;

public class SetForwardingTerminalCommand extends Command 
{
	private ITerminalServiceDAO terminalServiceDAO;
	
	@SuppressWarnings("unchecked")
	public void execute(Map<String, Object> params) throws Exception
	{
		TerminalTO terminal = (TerminalTO)params.get("terminal");
		List<ForwardInstructionTO> instructions = (List<ForwardInstructionTO>)params.get("forwardingInstructions");
			
		getTerminalServiceDAO().setForwarding(terminal, instructions, ssoToken);
	}

	/**
	 * @return the terminalServiceDAO
	 */
	public ITerminalServiceDAO getTerminalServiceDAO() {
		return terminalServiceDAO;
	}

	/**
	 * @param terminalServiceDAO the terminalServiceDAO to set
	 */
	public void setTerminalServiceDAO(ITerminalServiceDAO terminalServiceDAO) {
		this.terminalServiceDAO = terminalServiceDAO;
	}
}
