package com.nortel.rc.dao;

import java.net.URL;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.AgentTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ProviderTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.agentservice.AgentService;
import com.nortel.soa.oi.cct.agentservice.SOAOICCTAgentService;
import com.nortel.soa.oi.cct.types.Agent;
import com.nortel.soa.oi.cct.types.AgentCapabilities;
import com.nortel.soa.oi.cct.types.AgentReadyStatus;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.agentservice.AgentRequest;
import com.nortel.soa.oi.cct.types.agentservice.BooleanResponse;
import com.nortel.soa.oi.cct.types.agentservice.GetAgentContactTypesResponse;
import com.nortel.soa.oi.cct.types.agentservice.GetStaticVoiceTerminalResponse;
import com.nortel.soa.oi.cct.types.agentservice.GetSupervisorResponse;
import com.nortel.soa.oi.cct.types.agentservice.LoginRequest;
import com.nortel.soa.oi.cct.types.agentservice.RetrieveRequest;
import com.nortel.soa.oi.cct.types.agentservice.StringResponse;

public class AgentServiceDAO extends ServiceDAO implements IAgentServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.AgentServiceDAO");
	private String endPoint = null;
		
	public CallResult getReadyState(AgentTO agentTO, String sso) throws DAOException
    {  
		String methodName = "getReadyState():";
		AgentRequest request = new AgentRequest();
	    Agent agent = new Agent();
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    
	    SsoToken ssoToken = new SsoToken();	    
	    ssoToken.setToken(sso);
	    
	    request.setAgent(agent);
	    request.setSsoToken(ssoToken);
	    
	    BooleanResponse response = null;
	    
	    try {       	
	    	response = getPort().isReady(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(response != null ? response.isResponse() : false);
        return result;
    }
	
	public CallResult getNotReadyReasonCode(AgentTO agentTO, String sso) throws DAOException
    {  
		String methodName = "getNotReadyReasonCode():";
		AgentRequest request = new AgentRequest();
	    Agent agent = new Agent();
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    
	    SsoToken ssoToken = new SsoToken();	    
	    ssoToken.setToken(sso);
	    
	    request.setAgent(agent);
	    request.setSsoToken(ssoToken);
	    
	    StringResponse response = null;
	    
	    try {       	
	    	response = getPort().getNotReadyReasonCode(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(response.getResponse());
        return result;
    }
	
	public CallResult getStaticVoiceTerminal(AgentTO agentTO, String sso) throws DAOException
    {  
		String methodName = "getStaticVoiceTerminal():";
		AgentRequest request = new AgentRequest();
	    Agent agent = new Agent();
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    
	    SsoToken ssoToken = new SsoToken();	    
	    ssoToken.setToken(sso);
	    
	    request.setAgent(agent);
	    request.setSsoToken(ssoToken);
	    
	    GetStaticVoiceTerminalResponse response = null;
	    
	    try {       	
	    	response = getPort().getStaticVoiceTerminal(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    if(response != null && response.getTerminal() != null)
	    {
	    	Terminal cctTerminal = response.getTerminal();
	    	TerminalTO terminal = new TerminalTO();
        	terminal.setTerminalName(cctTerminal.getTerminalName());
        	terminal.setTerminalType(cctTerminal.getTerminalType().value());
        	terminal.setTerminalStatus(cctTerminal.getStatus());
        	ProviderTO provider = new ProviderTO();
        	provider.setProviderName(cctTerminal.getProvider() != null ? cctTerminal.getProvider().getProviderName() : "");
        	terminal.setProvider(provider);
        	result.setObject(terminal);
	    }
	    
        return result;
    }
	
	public CallResult getSupervisor(AgentTO agentTO, String sso) throws DAOException
    {  
		String methodName = "getSupervisor():";
		AgentRequest request = new AgentRequest();
	    Agent agent = new Agent();
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    
	    SsoToken ssoToken = new SsoToken();	    
	    ssoToken.setToken(sso);
	    
	    request.setAgent(agent);
	    request.setSsoToken(ssoToken);
	    
	    GetSupervisorResponse response = null;
	    
	    try {       	
	    	response = getPort().getSupervisor(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    
	    if(response != null && response.getAgent() != null)
	    {
	    	Agent cctAgent = response.getAgent();
		    AgentTO resAgent = new AgentTO();
		    resAgent.setAgentLoginId(cctAgent.getAgentLoginId());
		    resAgent.setAgentUsername(cctAgent.getUserName());
		    //resAgent.setAgentType(cctAgent.getAgentType().value());
		    result.setObject(resAgent);
	    }
        return result;
    }
	
	public CallResult isLoggedIn(AgentTO agentTO, String sso) throws DAOException
    {  
		String methodName = "isLoggedIn():";
		AgentRequest request = new AgentRequest();
	    Agent agent = new Agent();
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    
	    SsoToken ssoToken = new SsoToken();	    
	    ssoToken.setToken(sso);
	    
	    request.setAgent(agent);
	    request.setSsoToken(ssoToken);
	    
	    BooleanResponse response = null;
	    
	    try {
	    	response = getPort().isLoggedIn(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(response != null ? response.isResponse() : false);
        return result;
    }
	
	public CallResult login(AgentTO agentTO, int initialState, String pwd, String sso) throws DAOException
    {  
		String methodName = "login():";
		LoginRequest request = new LoginRequest();
	    Agent agent = new Agent();
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    
	    SsoToken ssoToken = new SsoToken();	    
	    ssoToken.setToken(sso);
	    
	    request.setAgent(agent);
	    request.setSsoToken(ssoToken);
	    
	    //request.setIntialState(initialState);
	    //eoinmc, AgentReadyStatus enum
	    request.setInitialState(initialState==2?AgentReadyStatus.READY:AgentReadyStatus.NOT_READY);
	    request.setPassword(pwd);
	    
	    try {
	    	getPort().login(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
        return null;
    }
	
    public CallResult getCapabilities(AgentTO agentTO, String sso) throws DAOException
    {
    	String methodName = "getCapabilities():";
		AgentRequest agentRequest = new AgentRequest();
        AgentCapabilities capabilities = null;
	    SsoToken ssoToken = new SsoToken();
	    Agent agent = new Agent();
	    
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    ssoToken.setToken(sso);
	    
	    agentRequest.setAgent(agent);
	    agentRequest.setSsoToken(ssoToken);

	    try {        	
	        capabilities = getPort().getCapabilities(agentRequest).getAgentCapabilities();
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    com.nortel.rc.dto.AgentCapabilitiesTO caps = new com.nortel.rc.dto.AgentCapabilitiesTO();
	    caps.setCanGetNotReadyReason(capabilities.isCanGetNotReadyReason());
	    caps.setCanGetReadyStatus(capabilities.isCanGetReadyStatus());
	    caps.setCanGetSupervisor(capabilities.isCanGetSupervisor());
	    caps.setCanLogin(capabilities.isCanLogin());
	    caps.setCanLogout(capabilities.isCanLogout());
	    caps.setCanRetrieve(capabilities.isCanRetrieve());
	    caps.setCanSetNotReadyReason(capabilities.isCanSetNotReadyReason());
	    caps.setCanSetReadyStatus(capabilities.isCanSetReadyStatus());
	    caps.setCanSetStaticVoiceTerminal(capabilities.isCanSetStaticVoiceTerminal());
	    
	    CallResult result = new CallResult();
	    result.setObject(caps);
        return result;
    }
    
    public CallResult retrieveContact(AgentTO agentTO, String externalContactId, String sso) throws DAOException
    {
    	String methodName = "retrieveContact():";
		RetrieveRequest request = new RetrieveRequest();
	    SsoToken ssoToken = new SsoToken();
	    Agent agent = new Agent();
	    
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    ssoToken.setToken(sso);
	    
	    request.setAgent(agent);
	    request.setContactExternalId(externalContactId);
	    request.setSsoToken(ssoToken);

	    try {        	
	        getPort().retrieve(request);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult getContactTypes(AgentTO agentTO, String sso) throws DAOException
    {
    	String methodName = "getContactTypes():";
		GetAgentContactTypesResponse response;
        AgentRequest agentRequest = new AgentRequest();
	    SsoToken ssoToken = new SsoToken();
	    
	    Agent agent = new Agent();
	    ssoToken.setToken(sso);
	    
	    agent.setAgentLoginId(agentTO.getAgentLoginId());
	    agent.setUserName(agentTO.getAgentUsername());
	    agentRequest.setAgent(agent);
	    agentRequest.setSsoToken(ssoToken);
	    
	    try {       	
	    	response = getPort().getContactTypes(agentRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(response.getContactTypes());
        return result;
    }
    
    /**
	 * @return {@link AgentService}
	 * Retrieves interface to be used by service consumers
	 */
	public AgentService getPort() throws DAOException {
		if(endPoint == null)
		{	      
			SOAOICCTAgentService ss = new SOAOICCTAgentService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
		
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(AgentService.class);
		AgentService service = (AgentService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);

		return service;
	}
}
