package com.nortel.rc.dao;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.AttachedDataTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.dto.ContactCapabilitiesTO;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.IntrinsicTO;
import com.nortel.rc.dto.KeyValuePairTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.dto.AttachedDataTO.AttachedDataType;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.contactservice.ContactService;
import com.nortel.soa.oi.cct.contactservice.SOAOICCTContactService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.AttachedData;
import com.nortel.soa.oi.cct.types.AttachmentType;
import com.nortel.soa.oi.cct.types.ByteArray;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.ContactCapabilities;
import com.nortel.soa.oi.cct.types.Intrinsic;
import com.nortel.soa.oi.cct.types.KeyValuePair;
import com.nortel.soa.oi.cct.types.KeyValuePairArray;
import com.nortel.soa.oi.cct.types.MediaTreatment;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.contactservice.AddressResponse;
import com.nortel.soa.oi.cct.types.contactservice.ContactAttachedDataRequest;
import com.nortel.soa.oi.cct.types.contactservice.ContactRequest;
import com.nortel.soa.oi.cct.types.contactservice.GetAttachedDataResponse;
import com.nortel.soa.oi.cct.types.contactservice.GetConnectionsResponse;
import com.nortel.soa.oi.cct.types.contactservice.GetContactTypesResponse;
import com.nortel.soa.oi.cct.types.contactservice.GiveTreatmentRequest;
import com.nortel.soa.oi.cct.types.contactservice.SetIntrinsicsRequest;
import com.nortel.soa.oi.cct.types.contactservice.SetUUIRequest;
import com.nortel.soa.oi.cct.types.contactservice.TerminalResponse;

public class ContactServiceDAO extends ServiceDAO implements IContactServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.ContactServiceDAO");
	private String endPoint = null;
	
	public CallResult getCalledAddress(String contactId, String sso) throws DAOException
    {
		String methodName = "getCalledAddress():"; 
		AddressResponse response;
		CallResult result = new CallResult();
        ContactRequest dataRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {       	
	    	response = getPort().getCalledAddress(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    if(response != null && response.getAddress() != null)
	    {
		    AddressTO address = new AddressTO();
		    address.setAddressName(response.getAddress().getAddressName());
		    address.setAddressType(response.getAddress().getAddressType().toString());
		    address.setAddressStatus(response.getAddress().getStatus());
		    result.setObject(address);
	    }
        return result;
    }
	
	public CallResult getCallingAddress(String contactId, String sso) throws DAOException
    {
		String methodName = "getCallingAddress():"; 
		AddressResponse response;
		CallResult result = new CallResult();
        ContactRequest dataRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {       	
	    	response = getPort().getCallingAddress(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    if(response != null && response.getAddress() != null)
	    {
		    AddressTO address = new AddressTO();
		    address.setAddressName(response.getAddress().getAddressName());
		    address.setAddressType(response.getAddress().getAddressType().toString());
		    address.setAddressStatus(response.getAddress().getStatus());
		 
		    result.setObject(address);
	    }
        return result;
    }
	
	public CallResult getCallingTerminal(String contactId, String sso) throws DAOException
    {
		String methodName = "getCallingTerminal():"; 
		TerminalResponse response;
		CallResult result = new CallResult();
        ContactRequest dataRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {       	
	    	response = getPort().getCallingTerminal(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    if(response != null && response.getTerminal() != null)
	    {
		    TerminalTO terminal = new TerminalTO();
		    terminal.setTerminalName(response.getTerminal().getTerminalName());
		    terminal.setTerminalType(response.getTerminal().getTerminalType().toString());
		    terminal.setTerminalStatus(response.getTerminal().getStatus());
		    
		    result.setObject(terminal);
	    }
        return result;
    }
	
	public CallResult getLastRedirectedAddress(String contactId, String sso) throws DAOException
    {
		String methodName = "getLastRedirectedAddress():"; 
		AddressResponse response;
		CallResult result = new CallResult();
        ContactRequest dataRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {       	
	    	response = getPort().getLastRedirectedAddress(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    if(response != null && response.getAddress() != null)
	    {
		    AddressTO address = new AddressTO();
		    address.setAddressName(response.getAddress().getAddressName());
		    address.setAddressType(response.getAddress().getAddressType().toString());
		    address.setAddressStatus(response.getAddress().getStatus());
		    
		    result.setObject(address);
	    }
        return result;
    }
	
	public CallResult getOriginalDestinationAddress(String contactId, String sso) throws DAOException
    {
		String methodName = "getOriginalDestinationAddress():"; 
		AddressResponse response;
        ContactRequest dataRequest = new ContactRequest();
        CallResult result = new CallResult();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {       	
	    	response = getPort().getOriginalDestinationAddress(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    AddressTO address = new AddressTO();
	    if(response != null && response.getAddress() != null)
	    {
		    address.setAddressName(response.getAddress().getAddressName());
		    address.setAddressType(response.getAddress().getAddressType().toString());
		    address.setAddressStatus(response.getAddress().getStatus());
		    result.setObject(address);
	    }
        return result;
    }
	
	public CallResult getContactTypes(String contactId, String sso) throws DAOException
    {
		String methodName = "getContactTypes():"; 
		GetContactTypesResponse response;
        ContactRequest dataRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {       	
	    	response = getPort().getContactTypes(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    if(response != null)
	    {
	    	result.setObject(response.getContactTypes());
	    }
        return result;
    }
	
    public CallResult setAttachedData(String contactId, AttachedDataTO dataToAttach, String sso) throws DAOException
    {
    	String methodName = "setAttachedData():"; 
		ContactAttachedDataRequest dataRequest = new ContactAttachedDataRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    AttachedData data = null;
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    if(dataToAttach != null)
	    {
	    	data = new AttachedData();
	    	
		    if(dataToAttach.getType().equals(AttachedDataType.STRING))
		    {	    
			    data.setType(AttachmentType.STRING);
			    data.setStringData(dataToAttach.getStringData());
		    }
		    else if(dataToAttach.getType().equals(AttachedDataType.BINARY))
		    {
		    	data.setType(AttachmentType.BINARY);
		    	ByteArray byteArray = new ByteArray();
		    	for(byte b : dataToAttach.getBinaryData())
	    		{
		    		byteArray.getItem().add(new Byte(b));
	    		}
			    data.setBinaryData(byteArray);
		    }
		    else
		    {
		    	data.setType(AttachmentType.KEY_VALUE_PAIRS);
		    	KeyValuePairArray kvps = new KeyValuePairArray();
		    	for(KeyValuePairTO kvpTO : dataToAttach.getKeyValueData())
		    	{
		    		KeyValuePair kvp = new KeyValuePair();
		    		kvp.setKey(kvpTO.getKey());
		    		kvp.setValue(kvpTO.getValue());
		    		kvps.getItem().add(kvp);
		    	}
			    data.setKeyValueData(kvps);
		    }
	    }
	    
	    dataRequest.setContact(contact);
	    dataRequest.setAttachedData(data);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {
	        getPort().setAttachedData(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult getAttachedData(String contactId, String sso) throws DAOException
    {
    	String methodName = "getAttachedData():"; 
		ContactRequest contactRequest = new ContactRequest();
        AttachedDataTO attachedData = new AttachedDataTO();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setContact(contact);
	    contactRequest.setSsoToken(ssoToken);
	    
	    AttachedData cctAttachedData;
	    GetAttachedDataResponse response = null;
	    try {
	    	response = getPort().getAttachedData(contactRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    if(response != null && response.getAttachedData() != null && response.getAttachedData().getType() != null)
	    {
	    	cctAttachedData = response.getAttachedData();
	    	if(cctAttachedData.getType().value().equals("STRING"))
	    	{
	    		attachedData.setType(AttachedDataType.STRING);
	    		attachedData.setStringData(cctAttachedData.getStringData());
	    	}
	    	else if(cctAttachedData.getType().value().equals("BINARY"))
	    	{
	    		attachedData.setType(AttachedDataType.BINARY);
	    		
	    		byte[] binaryData = new byte[cctAttachedData.getBinaryData().getItem().size()];
	    		int byteCount = 0;
	    		for(Byte b : cctAttachedData.getBinaryData().getItem())
	    		{
	    			binaryData[byteCount++] = b.byteValue();
	    		}
	    		attachedData.setBinaryData(binaryData);
	    	}
	    	else
	    	{
	    		attachedData.setType(AttachedDataType.KVP);
	    		KeyValuePairTO[] kvps = new KeyValuePairTO[cctAttachedData.getKeyValueData().getItem().size()];
	    		int counter = 0;
	    		for(KeyValuePair cctKvp : cctAttachedData.getKeyValueData().getItem())
	    		{
	    			KeyValuePairTO kvp = new KeyValuePairTO();
	    			kvp.setKey(cctKvp.getKey());
	    			kvp.setValue(cctKvp.getValue());
	    			kvps[counter] = kvp;
	    			counter++;
	    		}
	    		attachedData.setKeyValueData(kvps);
	    	}
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(attachedData);
        return result;
    }
    
    public CallResult getCapabilities(String contactId, String sso) throws DAOException
    {
    	String methodName = "getCapabilities():"; 
		ContactRequest contactRequest = new ContactRequest();
        CallResult result = null;
        ContactCapabilities capabilities = null;
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setContact(contact);
	    contactRequest.setSsoToken(ssoToken);

	    try {
	        capabilities = getPort().getCapabilities(contactRequest).getContactCapabilities();
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    if(capabilities != null)
	    {
		    ContactCapabilitiesTO caps = new ContactCapabilitiesTO();
		    caps.setCanAddParty(capabilities.isCanAddParty());
		    caps.setCanBargeIn(capabilities.isCanBargeIn());
		    caps.setCanDrop(capabilities.isCanDrop());
		    caps.setCanGetAttachedData(capabilities.isCanGetAttachedData());
		    caps.setCanGetCallingTerminal(capabilities.isCanGetCallingTerminal());
		    caps.setCanGetIntrinsics(capabilities.isCanGetIntrinsics());
		    caps.setCanGetLastRedirectedAddress(capabilities.isCanGetLastRedirectedAddress());
		    caps.setCanGetOriginalDestination(capabilities.isCanGetOriginalDestination());
		    caps.setCanGetUUI(capabilities.isCanGetUUI());
		    caps.setCanObserve(capabilities.isCanObserve());
		    caps.setCanSetAttachedData(capabilities.isCanSetAttachedData());
		    caps.setCanSetIntrinsics(capabilities.isCanSetIntrinsics());
		    caps.setCanSetUUI(capabilities.isCanSetUUI());
		    caps.setCanWhisper(capabilities.isCanWhisper());
		    
		    result = new CallResult();
		    result.setObject(caps);
	    }
	    
        return result;
    }
    
    public CallResult getConnections(String contactId, String sso) throws DAOException
    {
    	String methodName = "getConnections():"; 
		ContactRequest contactRequest = new ContactRequest();
        GetConnectionsResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setContact(contact);
	    contactRequest.setSsoToken(ssoToken);

	    try {
	        response = getPort().getConnections(contactRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    List<ConnectionTO> connections = new ArrayList<ConnectionTO>();
	    if(response != null)
	    {
	    	List<Connection> cctConnections = response.getConnection();
	    	for(int i=0; i<cctConnections.size();i++)
	    	{
	    		ConnectionTO conn = new ConnectionTO();
	    		conn.setConnectionId(cctConnections.get(i).getConnectionId());
	    		connections.add(conn);
	    	}
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(connections);
        return result;
    }
    
    public CallResult setUUIData(String contactId, String dataToAttach, String sso) throws DAOException
    {
    	String methodName = "setUUIData():"; 
		SetUUIRequest dataRequest = new SetUUIRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setUui(dataToAttach);
	    dataRequest.setSsoToken(ssoToken);
	    
	    try {
	        getPort().setUUI(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult getUUIData(String contactId, String sso) throws DAOException
    {
    	String methodName = "getUUIData():"; 
		ContactRequest contactRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setContact(contact);
	    contactRequest.setSsoToken(ssoToken);
	    
	    String uuiData;
	    try {
	        uuiData = getPort().getUUI(contactRequest).getUui();
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    result.setMessage(uuiData);
        return result;
    }
    
    public CallResult setIntrinsicData(String contactId, List<IntrinsicTO> intrinsicData, String sso) throws DAOException
    {
    	String methodName = "setIntrinsicData():"; 
		SetIntrinsicsRequest dataRequest = new SetIntrinsicsRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);	    
	    ssoToken.setToken(sso);
	    
	    dataRequest.setContact(contact);
	    dataRequest.setSsoToken(ssoToken);
	    
	    for(IntrinsicTO intrinsic : intrinsicData)
	    {
	    	if(intrinsic.getKey() != null && !intrinsic.getKey().equals("") && !intrinsic.isImmutable())
	    	{
		    	Intrinsic intr = new Intrinsic();
		    	intr.setKey(intrinsic.getKey());
		    	intr.setValue(intrinsic.getValue());
		    	intr.setImmutable(intrinsic.isImmutable());
		    	dataRequest.getIntrinsics().add(intr);
	    	}
	    }
	    
	    try {
	        getPort().setIntrinsics(dataRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
        return result;
    }
    
    public CallResult getIntrinsicData(String contactId, String sso) throws DAOException
    {
    	String methodName = "getIntrinsicData():"; 
		ContactRequest contactRequest = new ContactRequest();
	    SsoToken ssoToken = new SsoToken();
	    Contact contact = new Contact();
	    
	    contact.setContactId(contactId);
	    ssoToken.setToken(sso);
	    
	    contactRequest.setContact(contact);
	    contactRequest.setSsoToken(ssoToken);
	    
	    List<Intrinsic> intrinsicsList = null;
	    try {
	    	intrinsicsList = getPort().getIntrinsics(contactRequest).getIntrinsic();
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    List<IntrinsicTO> intrinsics = null;
	    if(intrinsicsList != null)
	    {
	    	intrinsics = new ArrayList<IntrinsicTO>(intrinsicsList.size());
		    for(Intrinsic intr : intrinsicsList)
		    {
		    	IntrinsicTO intrinsic = new IntrinsicTO();
		    	intrinsic.setKey(intr.getKey());
		    	intrinsic.setValue(intr.getValue());
		    	intrinsic.setImmutable(intr.isImmutable());
		    	intrinsics.add(intrinsic);
		    }
	    }	    
	    
	    CallResult result = new CallResult();
	    result.setObject(intrinsics);
        return result;
    }
    
    public CallResult giveMediaTreatment(AddressTO addr, ContactTO cont, String sso) throws DAOException
    {  
    	String methodName = "giveMediaTreatment():"; 
		GiveTreatmentRequest request = new GiveTreatmentRequest();
	    Address address = new Address();
	    Contact contact = new Contact();
	    MediaTreatment treatment = new MediaTreatment();
	    SsoToken ssoToken = new SsoToken();	    
	    
	    address.setAddressType(AddressType.valueOf(addr.getAddressType()));
	    address.setAddressName(addr.getAddressName());
		contact.setContactId(cont.getContactId());
		treatment.setInterruptible(true);
		treatment.setTreatmentAddress("treatmentAddress");
		treatment.setTreatmentParameter("String");
		treatment.setTreatmentTerminal("terminal");
		treatment.setType("");
	    ssoToken.setToken(sso);	    
	    
	    request.setSsoToken(ssoToken);
	    request.setAddress(address);
	    request.setContact(contact);
	    request.setMediaTreatment(treatment);
	    
	    try {       	
	    	getPort().giveTreatment(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
        return null;
    }
    
    /**
	 * @return {@link ContactService}
	 * Retrieves interface to be used by service consumers
	 */
	public ContactService getPort() throws DAOException {
		if(endPoint == null)
		{	      
			SOAOICCTContactService ss = new SOAOICCTContactService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
		
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(ContactService.class);
		ContactService service = (ContactService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);

		return service;
	}
}
