package com.nortel.rc.dao;

import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;

public interface IAgentTerminalServiceDAO extends IServiceDAO
{
	public CallResult getCapabilities(TerminalTO terminal, String sso) 
			throws DAOException;
	
	public CallResult isLoggedIn(TerminalTO terminal, String sso) 
			throws DAOException;
	
	public CallResult isForwarded(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult getDoNotDisturb(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult isReady(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult getActivityCode(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult setIsReady(TerminalTO term, boolean ready, String sso)
			throws DAOException;
	
	public CallResult setNotReadyReasonCode(TerminalTO term, String sso)
			throws DAOException;
	
	public CallResult getLoginId(TerminalTO term, String sso)
			throws DAOException;
}
