package com.nortel.rc.dao;

import java.net.URL;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ConnectionTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.routepointconnectionservice.RoutePointConnectionService;
import com.nortel.soa.oi.cct.routepointconnectionservice.SOAOICCTRoutePointConnectionService;
import com.nortel.soa.oi.cct.types.Address;
import com.nortel.soa.oi.cct.types.AddressType;
import com.nortel.soa.oi.cct.types.Connection;
import com.nortel.soa.oi.cct.types.MediaTreatment;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.ConnectionCapabilitiesResponse;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.ConnectionRequest;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.GiveMediaTreatmentRequest;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.RoutePointRetrieveRequest;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.RouteRequest;
import com.nortel.soa.oi.cct.types.routepointconnectionservice.RouteResponse;

public class RoutePointConnectionServiceDAO extends ServiceDAO implements IRoutePointConnectionServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.RoutePointConnectionServiceDAO");
	private String endPoint = null;
    
	public CallResult retrieve(AddressTO addr, ConnectionTO conn, String sso) throws DAOException
    {        
		String methodName = "retrieve():"; 
		RoutePointRetrieveRequest routePointRetrieveRequest = new RoutePointRetrieveRequest();
        SsoToken ssoToken = new SsoToken();
        
        if(addr != null)
        {
        	Address address = new Address();
        	address.setAddressName(addr.getAddressName());
        	address.setAddressType(AddressType.valueOf(addr.getAddressType()));
        	routePointRetrieveRequest.setAddress(address);
        }
        
        if(conn != null)
        {
        	Connection connection = new Connection();
        	connection.setConnectionId(conn.getConnectionId());
        	routePointRetrieveRequest.setRoutePointConnection(connection);
        }
        
		ssoToken.setToken(sso);
		
		routePointRetrieveRequest.setSsoToken(ssoToken);
	    
	    try {        	
	    	getPort().routePointRetrieve(routePointRetrieveRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }

        return null;
    }
	
	public CallResult route(String addr, ConnectionTO conn, String sso) throws DAOException
    {        
		String methodName = "route():"; 
		RouteRequest routeRequest = new RouteRequest();
        RouteResponse routeResponse = null;
        SsoToken ssoToken = new SsoToken();
        
        if(addr != null)
        {
        	routeRequest.setDestinationAddress(addr);
        }
        
        if(conn != null)
        {
        	Connection connection = new Connection();
        	connection.setConnectionId(conn.getConnectionId());
        	routeRequest.setRoutePointConnection(connection);
        }
        
		ssoToken.setToken(sso);
		
		routeRequest.setSsoToken(ssoToken);
	    
	    try {        	
	    	routeResponse = getPort().route(routeRequest);
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }

	    CallResult result = null;
	    if(routeResponse != null && routeResponse.getConnection() != null)
	    {
	        result = new CallResult();
	        Connection resultConn = routeResponse.getConnection();
	        ConnectionTO connection = new ConnectionTO();
	        connection.setConnectionId(resultConn.getConnectionId());
		    result.setObject(connection);
	    }
	    return result;
    }
	
	public CallResult giveMediaTreatment(String treatmentTerminal, String treatmentAddress, ConnectionTO connection, String type, String sso) throws DAOException
    {  
		String methodName = "giveMediaTreatment():"; 
		GiveMediaTreatmentRequest request = new GiveMediaTreatmentRequest();
	    MediaTreatment treatment = new MediaTreatment();
	    Connection conn = new Connection();
	    SsoToken ssoToken = new SsoToken();
		
		treatment.setInterruptible(true);
		treatment.setTreatmentAddress("");
		treatment.setTreatmentParameter(null);
		treatment.setTreatmentTerminal(null);
		treatment.setType(type);
		
		conn.setConnectionId(connection.getConnectionId());
		
	    ssoToken.setToken(sso);	    
	    
	    request.setSsoToken(ssoToken);
	    request.setConnection(conn);
	    request.setTreatment(treatment);
	    
	    try {       	
	    	getPort().giveMediaTreatment(request);
	
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
        return null;
    }
	
	public CallResult getCapabilities(ConnectionTO connection, String sso) throws DAOException
    {
	    logger.log(Level.WARN, "getCapabilities(): we don't implement capabilities for route point connections");
	    
	    //we need to introduce RoutePointConnectionCapabilitiesTO
	    com.nortel.rc.dto.ConnectionCapabilitiesTO caps = new com.nortel.rc.dto.ConnectionCapabilitiesTO();
	    CallResult result = new CallResult();
	    result.setObject(caps);
        return result;
    }
		
	public RoutePointConnectionService getPort() throws DAOException{
		if(endPoint == null)
		{			
			SOAOICCTRoutePointConnectionService ss = new SOAOICCTRoutePointConnectionService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
		
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(RoutePointConnectionService.class);
		RoutePointConnectionService service = (RoutePointConnectionService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);

		return service;
	}
}
