package com.nortel.rc.dao;

import java.net.URL;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import com.nortel.rc.dto.CallResult;
import com.nortel.rc.dto.ContactTO;
import com.nortel.rc.dto.StateSummaryTO;
import com.nortel.rc.dto.TerminalTO;
import com.nortel.rc.exception.DAOException;
import com.nortel.soa.oi.cct.terminalconnectionservice.SOAOICCTTerminalConnectionService;
import com.nortel.soa.oi.cct.terminalconnectionservice.TerminalConnectionService;
import com.nortel.soa.oi.cct.types.Contact;
import com.nortel.soa.oi.cct.types.SsoToken;
import com.nortel.soa.oi.cct.types.Terminal;
import com.nortel.soa.oi.cct.types.TerminalConnection;
import com.nortel.soa.oi.cct.types.TerminalConnectionCapabilities;
import com.nortel.soa.oi.cct.types.TerminalConnectionStateInfo;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.ContactResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.GetContactTypeResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.GetTerminalConnectionCapabilitiesResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.TerminalConnectionRequest;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.TerminalConnectionStateResponse;
import com.nortel.soa.oi.cct.types.terminalconnectionservice.TerminalResponse;

public class TerminalConnectionServiceDAO extends ServiceDAO implements ITerminalConnectionServiceDAO
{	
	private static Logger logger = Logger.getLogger("rc.dao.TerminalConnectionServiceDAO");
	private String endPoint = null;
    
    public CallResult getCapabilities(String terminalConnectionId, String sso) throws DAOException
    {
    	String methodName = "getCapabilities():"; 
		TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        TerminalConnectionCapabilities capabilities = null;
	    SsoToken ssoToken = new SsoToken();
	    TerminalConnection terminalConnection = new TerminalConnection();
	    
	    terminalConnection.setTerminalConnectionId(terminalConnectionId);
	    ssoToken.setToken(sso);
	    
	    terminalConnectionRequest.setTerminalConnection(terminalConnection);
	    terminalConnectionRequest.setSsoToken(ssoToken);

	    try {
	    	GetTerminalConnectionCapabilitiesResponse gtccr = getPort().getTerminalConnectionCapabilities(terminalConnectionRequest);
	    	if (gtccr != null) {
	    		capabilities = gtccr.getTerminalConnectionCapabilities();
	    	}
	        
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }   
	    
	    CallResult result = new CallResult();
	    if (capabilities != null) {
	    	com.nortel.rc.dto.TerminalConnectionCapabilitiesTO caps = new com.nortel.rc.dto.TerminalConnectionCapabilitiesTO();
		    caps.setCanAnswer(capabilities.isCanAnswer());
		    caps.setCanBlindTransfer(capabilities.isCanBlindTransfer());
		    caps.setCanCompleteConference(capabilities.isCanCompleteConference());
		    caps.setCanCompleteTransfer(capabilities.isCanCompleteTransfer());
		    caps.setCanConsult(capabilities.isCanConsult());
		    caps.setCanGenerateDTMF(capabilities.isCanGenerateDTMF());
		    caps.setCanHold(capabilities.isCanHold());
		    caps.setCanInitiateConference(capabilities.isCanInitiateConference());
		    caps.setCanInitiateTransfer(capabilities.isCanInitiateTransfer());
		    caps.setCanUnhold(capabilities.isCanUnhold());
          caps.setCanSetActivityCode(capabilities.isCanSetActivityCode());
          caps.setCanGetActivityCode(capabilities.isCanGetActivityCode());
		    
		    result.setObject(caps);
	    }

        return result;
    }
    
    public CallResult getTerminal(String terminalConnectionId, String sso) throws DAOException
    {
    	String methodName = "getTerminal():"; 
		TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        TerminalResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    TerminalConnection terminalConnection = new TerminalConnection();
	    
	    terminalConnection.setTerminalConnectionId(terminalConnectionId);
	    ssoToken.setToken(sso);
	    
	    terminalConnectionRequest.setTerminalConnection(terminalConnection);
	    terminalConnectionRequest.setSsoToken(ssoToken);

	    try {
	        response = getPort().getTerminal(terminalConnectionRequest);
	        
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }   
	    
	    TerminalTO terminal = new TerminalTO();
	    if(response != null)
	    {
	    	Terminal cctTerm = response.getTerminal();
	    	terminal.setTerminalName(cctTerm.getTerminalName());
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(terminal);
        return result;
    }
    
    public CallResult getState(String terminalConnectionId, String sso) throws DAOException
    {
    	String methodName = "getState():"; 
		TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
//        StateResponse response = null;
        TerminalConnectionStateResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    TerminalConnection terminalConnection = new TerminalConnection();
	    
	    terminalConnection.setTerminalConnectionId(terminalConnectionId);
	    ssoToken.setToken(sso);
	    
	    terminalConnectionRequest.setTerminalConnection(terminalConnection);
	    terminalConnectionRequest.setSsoToken(ssoToken);

	    try {
	        response = getPort().getState(terminalConnectionRequest);
	        
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    if(response != null)
	    {	    
		    StateSummaryTO stateSummary = new StateSummaryTO();
		    TerminalConnectionStateInfo stateInfo = response.getTerminalConnectionStateInfo();
		    //eoinmc 
//		    stateSummary.setCurrent(response.getStateInfo().getCurrentState().getState());
//		    stateSummary.setPrevious(response.getStateInfo().getLastState().getState());
//		    stateSummary.setReason(response.getStateInfo().getCurrentState().getReasonCode());

//		    stateSummary.setCurrent(response.getTerminalConnectionStateInfo().getCurrentState().getState().toString());
//		    stateSummary.setPrevious(response.getTerminalConnectionStateInfo().getLastState().getState().toString());
//		    stateSummary.setReason(response.getTerminalConnectionStateInfo().getCurrentState().getReasonCode().toString());
//		    result.setObject(stateSummary);
		    if(stateInfo != null)
		    {
		    	if(stateInfo.getCurrentState() != null)
		    	{
				    stateSummary.setCurrent(stateInfo.getCurrentState().getState().toString());
				    if(stateInfo.getCurrentState().getReasonCode() != null)
				    {
				    	stateSummary.setReason(stateInfo.getCurrentState().getReasonCode().toString());
				    }
		    	}
		    	if(stateInfo.getLastState() != null && stateInfo.getLastState().getState() != null)
		    	{
		    		stateSummary.setPrevious(stateInfo.getLastState().getState().toString());
		    	}
			    result.setObject(stateSummary);
		    }
	    }
        return result;
    }
    
    public CallResult getContactType(String terminalConnectionId, String sso) throws DAOException
    {
    	String methodName = "getContactType():"; 
		TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        GetContactTypeResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    TerminalConnection terminalConnection = new TerminalConnection();
	    
	    terminalConnection.setTerminalConnectionId(terminalConnectionId);
	    ssoToken.setToken(sso);
	    
	    terminalConnectionRequest.setTerminalConnection(terminalConnection);
	    terminalConnectionRequest.setSsoToken(ssoToken);

	    try {
	        response = getPort().getContactType(terminalConnectionRequest);
	        
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }
	    
	    CallResult result = new CallResult();
	    if (response != null) {
	    	result.setObject(response.getContactType());
	    }
	    
        return result;
    }
    
    public CallResult getConferenceConsult(String terminalConnectionId, String sso) throws DAOException
    {
    	String methodName = "getConferenceConsult():"; 
		TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        ContactResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    TerminalConnection terminalConnection = new TerminalConnection();
	    
	    terminalConnection.setTerminalConnectionId(terminalConnectionId);
	    ssoToken.setToken(sso);
	    
	    terminalConnectionRequest.setTerminalConnection(terminalConnection);
	    terminalConnectionRequest.setSsoToken(ssoToken);

	    try {
	        response = getPort().getConferenceConsultContact(terminalConnectionRequest);
	        
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }   
	    
	    ContactTO contact = null;
	    if(response != null && response.getContact() != null)
	    {
	    	contact = new ContactTO();
	    	Contact cctContact = response.getContact();
	    	contact.setContactId(cctContact.getContactId());
	    	contact.setExternalContactId(cctContact.getExternalContactId());
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(contact);
        return result;
    }
    
    public CallResult getTransferConsult(String terminalConnectionId, String sso) throws DAOException
    {
    	String methodName = "getTransferConsult():"; 
		TerminalConnectionRequest terminalConnectionRequest = new TerminalConnectionRequest();
        ContactResponse response = null;
	    SsoToken ssoToken = new SsoToken();
	    TerminalConnection terminalConnection = new TerminalConnection();
	    
	    terminalConnection.setTerminalConnectionId(terminalConnectionId);
	    ssoToken.setToken(sso);
	    
	    terminalConnectionRequest.setTerminalConnection(terminalConnection);
	    terminalConnectionRequest.setSsoToken(ssoToken);

	    try {
	        response = getPort().getTransferConsultContact(terminalConnectionRequest);
	        
	    } catch (Exception e) {
	    	logExecption(logger, methodName, e);
	        throw new DAOException(e);
	    }finally{
	    	logger.log(Level.INFO, methodName+" sso["+sso+"] endpoint : "+ endPoint);
	    }   
	    
	    ContactTO contact = null;
	    if(response != null && response.getContact() != null)
	    {
	    	contact = new ContactTO();
	    	Contact cctContact = response.getContact();
	    	contact.setContactId(cctContact.getContactId());
	    	contact.setExternalContactId(cctContact.getExternalContactId());
	    }
	    
	    CallResult result = new CallResult();
	    result.setObject(contact);
        return result;
    }
    
    /**
	 * @return {@link TerminalConnectionService}
	 * Retrieves interface to be used by service consumers
	 */
	public TerminalConnectionService getPort() throws DAOException
	{
		if(endPoint == null)
		{	      
			SOAOICCTTerminalConnectionService ss = new SOAOICCTTerminalConnectionService(getWsdlUrl(), getServiceQName());
			URL wsdlDoc = ss.getWSDLDocumentLocation();
			endPoint = wsdlDoc.getProtocol()+"://"+wsdlDoc.getAuthority()+wsdlDoc.getPath();
		}
		
		JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
		factory.setServiceClass(TerminalConnectionService.class);
		TerminalConnectionService service = (TerminalConnectionService) factory.create();
		((BindingProvider)service).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, endPoint);

		return service;
	}
}
