package com.nortel.rc.dto;

public class AddressTO {

	private String addressName;
	private String addressType;
	private String addressStatus;
	private ProviderTO provider;
	private boolean doNotDisturb = false;
	private boolean forwarding = false;
	private boolean outOfService = false;
	private AddressCapabilitiesTO addressCapabilities;
	private boolean isControlled = false;
	private String defaultTreatment;

	/**
	 * @return the defaultTreatment
	 */
	public String getDefaultTreatment() {
		return defaultTreatment;
	}

	/**
	 * @param defaultTreatment the defaultTreatment to set
	 */
	public void setDefaultTreatment(String defaultTreatment) {
		this.defaultTreatment = defaultTreatment;
	}

	/**
	 * @return the addressName
	 */
	public String getAddressName() {
		return addressName;
	}

	/**
	 * @param addressName the addressName to set
	 */
	public void setAddressName(String addressName) {
		this.addressName = addressName;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AddressTO other = (AddressTO) obj;
		if (addressName == null) {
			if (other.addressName != null)
				return false;
		} else if (!addressName.equals(other.addressName))
			return false;
		return true;
	}

	/**
	 * @return the addressCapabilities
	 */
	public AddressCapabilitiesTO getCapabilities() {
		return addressCapabilities;
	}

	/**
	 * @param addressCapabilities the addressCapabilities to set
	 */
	public void setCapabilities(AddressCapabilitiesTO addressCapabilities) {
		this.addressCapabilities = addressCapabilities;
	}

	/**
	 * @return the addressType
	 */
	public String getAddressType() {
		return addressType;
	}

	/**
	 * @param addressType the addressType to set
	 */
	public void setAddressType(String addressType) {
		this.addressType = addressType;
	}

	/**
	 * @return the addressStatus
	 */
	public String getAddressStatus() {
		return addressStatus;
	}

	/**
	 * @param addressStatus the addressStatus to set
	 */
	public void setAddressStatus(String addressStatus) {
		this.addressStatus = addressStatus;
	}

	/**
	 * @return the doNotDisturb
	 */
	public boolean isDoNotDisturb() {
		return doNotDisturb;
	}

	/**
	 * @param doNotDisturb the doNotDisturb to set
	 */
	public void setDoNotDisturb(boolean doNotDisturb) {
		this.doNotDisturb = doNotDisturb;
	}

	/**
	 * @return the forwarding
	 */
	public boolean isForwarding() {
		return forwarding;
	}

	/**
	 * @param forwarding the forwarding to set
	 */
	public void setForwarding(boolean forwarding) {
		this.forwarding = forwarding;
	}

	/**
	 * @return the provider
	 */
	public ProviderTO getProvider() {
		return provider;
	}

	/**
	 * @param provider the provider to set
	 */
	public void setProvider(ProviderTO provider) {
		this.provider = provider;
	}

	/**
	 * @return the outOfService
	 */
	public boolean isOutOfService() {
		return outOfService;
	}

	/**
	 * @param outOfService the outOfService to set
	 */
	public void setOutOfService(boolean outOfService) {
		this.outOfService = outOfService;
	}

	/**
	 * @return the isControlled
	 */
	public boolean isControlled() {
		return isControlled;
	}

	/**
	 * @param isControlled the isControlled to set
	 */
	public void setControlled(boolean isControlled) {
		this.isControlled = isControlled;
	}
}
