package com.nortel.rc.gui;

import javax.swing.tree.DefaultMutableTreeNode;

import com.nortel.rc.dto.AddressTO;
import com.nortel.rc.dto.TerminalTO;

@SuppressWarnings("serial")
public class DeviceMutableTreeNode extends DefaultMutableTreeNode {
	
	private static final String TERMINAL = "TerminalTO";
	private static final String ADDRESS = "AddressTO";
	private static final String OTHER = "Other";
	private String userObjectType = null;

	public DeviceMutableTreeNode() {
		super();
		this.setUserObjectType(null);
	}

	public DeviceMutableTreeNode(Object userObject) {
		super(userObject);
		this.setUserObjectType(userObject);
	}

	public DeviceMutableTreeNode(Object userObject, boolean allowsChildren) {
		super(userObject, allowsChildren);
		this.setUserObjectType(userObject);
	}
	
	private void setUserObjectType(Object userObject) {
		if (userObject instanceof TerminalTO) {
			this.userObjectType = TERMINAL;
		} else if (userObject instanceof AddressTO) {
			this.userObjectType = ADDRESS;
		} else {
			this.userObjectType = OTHER;
		}
	}
	
	public boolean hasChildren() {
		return super.getChildCount()!=0;
	}
	
	private String getObjectName() {
		String result = null;
		if (this.userObjectType.equals(TERMINAL)) {
			TerminalTO object = (TerminalTO)super.getUserObject();
			result = object.getTerminalName();
		} else if (this.userObjectType.equals(ADDRESS)) {
			AddressTO object = (AddressTO)super.getUserObject();
			result = object.getAddressName();
		} else {
			result = super.getUserObject().toString();
		}
		return result;
	}
	
	public String toString() {
		return this.getObjectName().toString();
	}
	
	public boolean isTerminal() {
		return this.userObjectType.equals(TERMINAL);
	}
	
	public boolean isAddress() {
		return this.userObjectType.equals(ADDRESS);
	}
}
