﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace OpenInterfacesProvider
{
    /// <summary>
    /// Sample web service to be used to give example of how to configure a solution that will be compliant with Email Open Interfaces requirements.
    /// Four sample methods are provided. These contain shell implementations and are intended to be used purely for illustrative purposes.
    /// If nulls are returned then these will be disregarded by Email Open Interfaces and as such can be used in cases where exceptions are caught 
    /// or where the the value should be left unchanged in CCMM.
    /// </summary>
    [ServiceContract]
    public interface IEmailOpenInterfacesService
    {
        #region Correct format methods only

        /// <summary>
        /// Input array:
        ///     [0]: From address
        ///     [1]: Subject
        /// Output array:
        ///     [0]: Subject
        ///     [1]: Priority
        /// </summary>
        /// <param name="inputParameters"></param>
        /// <returns></returns>
        [OperationContract]
        string[] PrioritiseBasedOnFromAddress(string[] inputParameters);

        /// <summary>
        /// Input array:
        ///     [0]: Plain text body of email
        ///     [1]: HTML Body of email
        /// Output array:
        ///     [0]: Plain text body of email
        ///     [1]: HTML Body of email
        /// </summary>
        /// <param name="inputParameters"></param>
        /// <returns></returns>
        [OperationContract]
        string[] DeleteCreditCardNumber(string[] inputParameters);

        /// <summary>
        /// Input array:
        ///     [0]: Subject
        /// Output array:
        ///     [0]: Custom field name
        ///     [1]: Custom field value
        /// </summary>
        /// <param name="inputParameters"></param>
        /// <returns></returns>
        [OperationContract]
        string[] GetTrackingId(string[] inputParameters);

        /// <summary>
        /// Input array:
        ///     [0]: Plain text body of email
        ///     [1]: HTML Body of email
        ///     [2]: Subject
        /// Output array:
        ///     [0]: Plain text body of email
        ///     [1]: HTML Body of email
        ///     [2]: Subject
        /// </summary>
        /// <param name="inputParameters"></param>
        /// <returns></returns>
        [OperationContract]
        string[] Translate(string[] inputParameters);

        #endregion
    }
}