// ///////////////////////////////////////////////////////////////////////////
//
// FilterInterceptor.java
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described
// in licenses/SDKLicense.doc
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
// or Avaya Policy
// /////////////////////////////////////////////////////////////////////////////

package com.avaya.customer.example.servlet;

import com.avaya.customer.example.servlet.api.ChatMessage;
import com.avaya.customer.example.servlet.api.RestFilterAPI;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;

@Path("filter")
public class SampleFilterService implements RestFilterAPI {

    @Context
    HttpServletResponse response;

    @Override
    public List<ChatMessage> filterChatConversation(List<ChatMessage> transcript) {
        List<ChatMessage> returnedList = new ArrayList<>();
        for (ChatMessage chatMessage : transcript) {
            returnedList.add(new ChatMessage(chatMessage.getSender(), chatMessage.getMessage() + " been filtered",
                    chatMessage.getDate(), chatMessage.getMessageType()));
        }
        return returnedList;
    }

    @Override
    public String echo(String message) {
        return message;
    }

}
