// ///////////////////////////////////////////////////////////////////////////
//
// ChatMessage.java
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described
// in licenses/SDKLicense.doc
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
// or Avaya Policy
// /////////////////////////////////////////////////////////////////////////////

package com.avaya.customer.example.servlet.api;

import java.util.Calendar;

/**
 * Representation of messages sent during a chat for transcript filtering
 */
public class ChatMessage {

    /**
     * Types of message that can be sent to the transcript filtering service
     */
    public static enum TranscriptMessageType {
        /** A message visible to both agents and customers */
        NORMAL,
        /** A message configured to send when the first agent joins the room */
        WELCOMEMESSAGE,
        /** A message only visible to agents in the room */
        WHISPER,
        /** A comfort message automatically sent due to agent inactivity */
        COMFORTMESSAGE,
        /** A page push URL. The 'message' field will contain the URL */
        PAGEPUSH
    }

    /** The display name of the sender. */
    private String sender;

    /** The message or page push URL. */
    private String message;

    /** The timestamp of the message. */
    private Calendar date;

    /** The message type. */
    private TranscriptMessageType messageType;

    /**
     * Empty constructor for Json
     */
    public ChatMessage() {

    }

    /**
     * Instantiates a new chat message.
     * @param sender the sender
     * @param message the message
     * @param date the date
     * @param messageType the message type
     */
    public ChatMessage(String sender, String message, Calendar date, TranscriptMessageType messageType) {
        this.sender = sender;
        this.message = message;
        this.date = date;
        this.messageType = messageType;
    }

    /**
     * Gets the sender.
     * @return the sender
     */
    public String getSender() {
        return sender;
    }

    /**
     * Sets the sender.
     * @param sender the new sender
     */
    public void setSender(String sender) {
        this.sender = sender;
    }

    /**
     * Gets the message.
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * Sets the message.
     * @param message the new message
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * Gets the date.
     * @return the date
     */
    public Calendar getDate() {
        return date;
    }

    /**
     * Sets the date.
     * @param the new date
     */
    public void setDate(Calendar date) {
        this.date = date;
    }

    /**
     * @return the messageType
     */
    public TranscriptMessageType getMessageType() {
        return messageType;
    }

    /**
     * @param messageType the messageType to set
     */
    public void setMessageType(TranscriptMessageType messageType) {
        this.messageType = messageType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChatMessage [sender=");
        builder.append(sender);
        builder.append(", message=");
        builder.append("********");
        builder.append(", date=");
        builder.append(date);
        builder.append(", messageType=");
        builder.append(messageType);
        builder.append("]");
        return builder.toString();
    }

}
