﻿//////////////////////////////////////////////////////////////////////////////
// Contact.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////
using Nortel.CCT;
using System;
using System.Collections.Generic;

namespace CustomDesktop
{
    public class Contact
    {
        // Create a logger for use in this class
        private static readonly log4net.ILog log = log4net.LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
        private Dictionary<String,String> intrinsics = new Dictionary<String,String>();
        private long contactID = -1;
        private bool isConsult = false;
        private long parentID = -1;

        public long ID { get { return contactID; } internal set { contactID = value; } }
        public long ParentID { get { return parentID; } internal set { parentID = value; } }
        public Dictionary<String, String> Intrinsics { get { return intrinsics; } internal set { intrinsics = value; } }

        public Contact(IContact contact)
        {
            try
            {
                this.contactID = long.Parse(contact.ID);
                if (contact.Intrinsics != null)
                {
                    foreach (String key in contact.Intrinsics.Keys)
                    {
                        if (key.Equals("ConsultContactParentId"))
                        {
                            isConsult = true;
                            parentID = long.Parse(contact.Intrinsics[key]);
                        }
                        intrinsics.Add(key, contact.Intrinsics[key]);
                    }
                }
                else
                {
                    log.Info(string.Format("Contact created with no intrinsics"));
                }
            }
            catch (Exception ex)
            {
                log.Error("exception occured in Contact constructor", ex);
            }
        }

        public bool IsConsultContact()
        {
            return isConsult;
        }

        public override string ToString()
        {
            return string.Format("Contact ID {0} Parent ID {1} ",contactID,parentID);
        }

        public void AddCustomIntrinsics(Dictionary<string,string> customIntrinsics)
        {
            log.Info("Adding custom intrinsics");
            foreach (KeyValuePair<string, string> pair in customIntrinsics)
            {
                log.Info("Adding custom intrinsic | Key:" + pair.Key + " Value: " + pair.Value);
                intrinsics.Add(pair.Key, pair.Value);
            }
        }
    }
}
