﻿//////////////////////////////////////////////////////////////////////////////
// WSNotifier.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////


using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;

namespace EncoderDecoder
{
    internal class WSNotifier : IDisposable
    {
        private static readonly log4net.ILog log = log4net.LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
        private volatile bool _enabled;
        private Queue<WSNotificationMessage> _queue;
        private object _sync;
        private ManualResetEvent _waitHandle;

        public WSNotifier()
        {
            _enabled = true;
            _queue = new Queue<WSNotificationMessage>();
            _sync = ((ICollection)_queue).SyncRoot;
            _waitHandle = new ManualResetEvent(false);

            ThreadPool.QueueUserWorkItem(
              state =>
              {
                  while (_enabled || Count > 0)
                  {
                      var msg = Dequeue();
                      if (msg != null)
                      {
#if UBUNTU
              var nf = new Notification (msg.Summary, msg.Body, msg.Icon);
              nf.AddHint ("append", "allowed");
              nf.Show ();
#else
                          Console.WriteLine(msg);
                          log.Info("^^Message body from WebSocket " + msg.Body);
#endif
                      }
                      else
                      {
                          Thread.Sleep(500);
                      }
                  }

                  _waitHandle.Set();
              });
        }

        public int Count
        {
            get
            {
                lock (_sync)
                    return _queue.Count;
            }
        }

        private WSNotificationMessage Dequeue()
        {
            lock (_sync)
                return _queue.Count > 0
                       ? _queue.Dequeue()
                       : null;
        }

        public void Close()
        {
            _enabled = false;
            _waitHandle.WaitOne();
            _waitHandle.Close();
        }

        public void Notify(WSNotificationMessage message)
        {
            lock (_sync)
                if (_enabled) { 
                    _queue.Enqueue(message);
                }
        }

        void IDisposable.Dispose()
        {
            Close();
        }
    }
}