﻿//////////////////////////////////////////////////////////////////////////////
// NewMessageNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class NewMessageNotificationTest
    {
        [TestMethod]
        public void NewMessageNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""newMessage"",
                                        ""guid"" : 123456,
                                        ""displayName"" : ""Customer"",
                                        ""message"" : ""Test message from agent"",
                                        ""messageType"" : ""normal"",
                                        ""timestamp"" : 1427294421123
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            NewMessageNotification note = (NewMessageNotification)jdecode.Decode(jsonResponse);

            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "newMessage");
            Assert.AreEqual(note.body.guid, 123456);
            Assert.AreEqual(note.body.displayName, "Customer");
            Assert.AreEqual(note.body.message, "Test message from agent");
            Assert.AreEqual(note.body.messageType, "normal");
        }

        [TestMethod]
        public void NewMessageNotificationTest_SimpleDecode2()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.1"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""newMessage"",
                                        ""sender"" : {
                                            ""type"" : ""agent"",
                                            ""agentId"" : ""55""
                                        },
                                        ""guid"" : 223456,
                                        ""displayName"" : ""Customer2"",
                                        ""message"" : ""Test message from2agent"",
                                        ""messageType"" : ""whisper"",
                                        ""timestamp"" : 1427294421123
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            NewMessageNotification note = (NewMessageNotification)jdecode.Decode(jsonResponse);

            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.1");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "newMessage");
            Assert.AreEqual(note.body.sender.type, "agent");
            Assert.AreEqual(note.body.sender.agentId, "55");
            Assert.AreEqual(note.body.guid, 223456);
            Assert.AreEqual(note.body.displayName, "Customer2");
            Assert.AreEqual(note.body.message, "Test message from2agent");
            Assert.AreEqual(note.body.messageType, "whisper");
        }

        [TestMethod]
        public void NewMessageNotificationTest_ComfortMessage()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.1"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""newMessage"",
                                        ""sender"" : {
                                            ""type"" : ""customer""
                                        },
                                        ""guid"" : 223456,
                                        ""displayName"" : ""Customer2"",
                                        ""message"" : ""Test message from2agent"",
                                        ""messageType"" : ""comfortMessage"",
                                        ""timestamp"" : 1427294421123
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            NewMessageNotification note = (NewMessageNotification)jdecode.Decode(jsonResponse);

            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.1");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "newMessage");
            Assert.AreEqual(note.body.sender.type, "customer");
            Assert.AreEqual(note.body.sender.agentId, null);
            Assert.AreEqual(note.body.guid, 223456);
            Assert.AreEqual(note.body.displayName, "Customer2");
            Assert.AreEqual(note.body.message, "Test message from2agent");
            Assert.AreEqual(note.body.messageType, "comfortMessage");

        }

        [TestMethod]
        public void NewMessageNotificationTest_WelcomeMessage()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.1"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""newMessage"",
                                        ""guid"" : 223456,
                                        ""displayName"" : ""Customer2"",
                                        ""message"" : ""Test message from2agent"",
                                        ""messageType"" : ""welcomeMessage"",
                                        ""timestamp"" : 1427294421123
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            NewMessageNotification note = (NewMessageNotification)jdecode.Decode(jsonResponse);

            String convertedTimestamp = JDecoder.ConvertFromUnixTime(note.body.timestamp);

            Assert.AreEqual(note.apiVersion, "1.1");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "newMessage");
            Assert.AreEqual(note.body.guid, 223456);
            Assert.AreEqual(note.body.displayName, "Customer2");
            Assert.AreEqual(note.body.message, "Test message from2agent");
            Assert.AreEqual(note.body.messageType, "welcomeMessage");
        }
    }
}
