﻿//////////////////////////////////////////////////////////////////////////////
// NewPagePushNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class NewPagePushNotificationTest
    {
        [TestMethod]
        public void NewPagePushNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""pagePush"",
                                        ""guid"" : 123456,
                                        ""sender"" : {
                                            ""type"" : ""agent"",
                                            ""agentId"" : ""55""
                                        },
                                        ""displayName"" : ""Frank"",
                                        ""url"" : ""www.avaya.com"",
                                        ""destination"" : ""newTab"",
                                        ""timestamp"": 1434019311123
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            NewPagePushNotification note = (NewPagePushNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "pagePush");
            Assert.AreEqual(note.body.guid, 123456);
            Assert.AreEqual(note.body.sender.type, "agent");
            Assert.AreEqual(note.body.sender.agentId, "55");
            Assert.AreEqual(note.body.displayName, "Frank");
            Assert.AreEqual(note.body.url, "www.avaya.com");
            Assert.AreEqual(note.body.destination, "newTab");
            Assert.AreEqual(note.body.timestamp, 1434019311123);
        }

    }
}
