﻿using Newtonsoft.Json;
using System;

namespace EncoderDecoder.Requests
{
    /// <summary>
    /// Request sent that allows agent to send a page push with intended destination.
    /// </summary>
    public class NewPagePushRequest : BaseRequest
    {
        public NewPagePushRequest()
        {
            this.body = new Body();
        }

        [JsonProperty(Order = 1)]
        public JSapiVersion apiVersion { get; set; }

        [JsonProperty(Order = 2)]
        public readonly JStype type = JStype.request;

        [JsonProperty(Order = 3)]
        public Body body { get; set; }

        public class Body
        {
            public readonly JSmethod method = JSmethod.pagePush;
            public long guid { get; set; }
            public string url { get; set; }
            public JSpagePushDestination destination { get; set; }
        }

        /// <summary>
        /// Encodes this object to JSON string.
        /// </summary>
        /// <returns>json encoded string.</returns>
        public override String Encode()
        {
            return JsonConvert.SerializeObject(this, Formatting.None);
        }

    }
}