﻿//////////////////////////////////////////////////////////////////////////////
// AgentGetObservedIntrinsicsNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentGetObservedIntrinsicsNotificationTest
    {
        [TestMethod]
        public void AgentGetObservedIntrinsicsNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""getObservedIntrinsics"",
                                        ""agents"" : [
                                            {
                                                ""agentId"" : ""432111"",
                                                ""agentName"" : ""John Smith"",
                                                ""conversations"" : [
                                                    {
                                                        ""guid"" : 111222,
                                                        ""conversationLength_inSeconds"" : 30,
                                                        ""lastMessageOut_inSeconds"" : 30,
                                                        ""lastMessageIn_inSeconds"" : 30,
                                                        ""numberOfAgentMessages"" : 10,
                                                        ""numberOfUnansweredCustomerMessages"" : 3
                                                    },
                                                    {
                                                        ""guid"" : 555666,
                                                        ""conversationLength_inSeconds"" : 20,
                                                        ""lastMessageOut_inSeconds"" : 20,
                                                        ""lastMessageIn_inSeconds"" : 20,
                                                        ""numberOfAgentMessages"" : 5,
                                                        ""numberOfUnansweredCustomerMessages"" : 1
                                                    }
                                                ]
                                            },
                                            {
                                                ""agentId"" : ""553311"",
                                                ""agentName"" : ""David Jones"",
                                                ""conversations"" : [
                                                    {
                                                        ""guid"" : 9990,
                                                        ""conversationLength_inSeconds"" : 30,
                                                        ""lastMessageOut_inSeconds"" : 30,
                                                        ""lastMessageIn_inSeconds"" : 30,
                                                        ""numberOfAgentMessages"" : 10,
                                                        ""numberOfUnansweredCustomerMessages"" : 3
                                                    },
                                                    {
                                                        ""guid"" : 8880,
                                                        ""conversationLength_inSeconds"" : 20,
                                                        ""lastMessageOut_inSeconds"" : 20,
                                                        ""lastMessageIn_inSeconds"" : 20,
                                                        ""numberOfAgentMessages"" : 5,
                                                        ""numberOfUnansweredCustomerMessages"" : 1
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentGetObservedIntrinsicsNotification note = (AgentGetObservedIntrinsicsNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "getObservedIntrinsics");

            //Agent 1
            Assert.AreEqual(note.body.agents[0].agentId, "432111");
            Assert.AreEqual(note.body.agents[0].agentName, "John Smith");

            Assert.AreEqual(note.body.agents[0].conversations[0].guid, 111222);
            Assert.AreEqual(note.body.agents[0].conversations[0].conversationLength_inSeconds, 30);
            Assert.AreEqual(note.body.agents[0].conversations[0].lastMessageOut_inSeconds, 30);
            Assert.AreEqual(note.body.agents[0].conversations[0].lastMessageIn_inSeconds, 30);
            Assert.AreEqual(note.body.agents[0].conversations[0].numberOfAgentMessages, 10);
            Assert.AreEqual(note.body.agents[0].conversations[0].numberOfUnansweredCustomerMessages, 3);

            Assert.AreEqual(note.body.agents[0].conversations[1].guid, 555666);
            Assert.AreEqual(note.body.agents[0].conversations[1].conversationLength_inSeconds, 20);
            Assert.AreEqual(note.body.agents[0].conversations[1].lastMessageOut_inSeconds, 20);
            Assert.AreEqual(note.body.agents[0].conversations[1].lastMessageIn_inSeconds, 20);
            Assert.AreEqual(note.body.agents[0].conversations[1].numberOfAgentMessages, 5);
            Assert.AreEqual(note.body.agents[0].conversations[1].numberOfUnansweredCustomerMessages, 1);

            //Agent 2
            Assert.AreEqual(note.body.agents[1].agentId, "553311");
            Assert.AreEqual(note.body.agents[1].agentName, "David Jones");

            Assert.AreEqual(note.body.agents[1].conversations[0].guid, 9990);
            Assert.AreEqual(note.body.agents[1].conversations[0].conversationLength_inSeconds, 30);
            Assert.AreEqual(note.body.agents[1].conversations[0].lastMessageOut_inSeconds, 30);
            Assert.AreEqual(note.body.agents[1].conversations[0].lastMessageIn_inSeconds, 30);
            Assert.AreEqual(note.body.agents[1].conversations[0].numberOfAgentMessages, 10);
            Assert.AreEqual(note.body.agents[1].conversations[0].numberOfUnansweredCustomerMessages, 3);

            Assert.AreEqual(note.body.agents[1].conversations[1].guid, 8880);
            Assert.AreEqual(note.body.agents[1].conversations[1].conversationLength_inSeconds, 20);
            Assert.AreEqual(note.body.agents[1].conversations[1].lastMessageOut_inSeconds, 20);
            Assert.AreEqual(note.body.agents[1].conversations[1].lastMessageIn_inSeconds, 20);
            Assert.AreEqual(note.body.agents[1].conversations[1].numberOfAgentMessages, 5);
            Assert.AreEqual(note.body.agents[1].conversations[1].numberOfUnansweredCustomerMessages, 1);
        }

    }


}

