﻿//////////////////////////////////////////////////////////////////////////////
// IsTypingNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class IsTypingNotificationTest
    {
        [TestMethod]
        public void IsTypingNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""isTyping"",
                                        ""sender"": {
                                                    ""type"": ""agent"",
                                                    ""agentId"": ""1234""
                                                },
                                        ""guid"" : 123456,
                                        ""displayName"" : ""John"",
                                        ""timestamp"" : 1427294421,
                                        ""isTyping"" : true,
                                        ""messageType"" : ""normal""
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            IsTypingNotification note = (IsTypingNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "isTyping");
            Assert.AreEqual(note.body.sender.type, "agent");
            Assert.AreEqual(note.body.sender.agentId, "1234");
            Assert.AreEqual(note.body.guid, 123456);
            Assert.AreEqual(note.body.displayName, "John");
            Assert.AreEqual(note.body.timestamp, 1427294421);
            Assert.IsTrue(note.body.isTyping);
            Assert.AreEqual(note.body.messageType, "normal");
            

        }

        [TestMethod]
        public void IsTypingNotificationTest_SimpleDecode2()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""isTyping"",
                                        ""sender"": {
                                                    ""type"": ""customer""
                                                },
                                        ""guid"" : 123456,
                                        ""displayName"" : ""John"",
                                        ""timestamp"" : 1427294421,
                                        ""isTyping"" : true,
                                        ""messageType"" : ""normal""
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            IsTypingNotification note = (IsTypingNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "isTyping");
            Assert.AreEqual(note.body.sender.type, "customer");
            Assert.AreEqual(note.body.guid, 123456);
            Assert.AreEqual(note.body.displayName, "John");
            Assert.AreEqual(note.body.timestamp, 1427294421);
            Assert.IsTrue(note.body.isTyping);
            Assert.AreEqual(note.body.messageType, "normal");


        }

    }
}
