﻿//////////////////////////////////////////////////////////////////////////////
// AgentJoinRoomRequestTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Requests;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentJoinRoomRequestTest
    {
        [TestMethod]
        public void AgentJoinRoomRequestTest_SimpleEncode()
        {
            String jsonExpected = @"{""apiVersion"":""1.0"",""type"":""request"",""body"":{""method"":""agentJoinRoom"",""guid"":123456,""joinType"":""active""}}";

            AgentJoinRoomRequest temp = new AgentJoinRoomRequest();
            temp.apiVersion = AgentJoinRoomRequest.JSapiVersion.one_point_zero;

            temp.body.guid = 123456;
            temp.body.joinType = AgentJoinRoomRequest.JSjoinType.active;

            JEncoder e = new JEncoder();
            String response = e.Encode(temp);


            Assert.AreEqual(response, jsonExpected);



        }
    }
}
