﻿//////////////////////////////////////////////////////////////////////////////
// ChatIntrinsics.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder.Notifications;
using System;

namespace CustomDesktop
{
    internal class ChatIntrinsics
    {
        // Create a logger for use in this class
        private static readonly log4net.ILog log = log4net.LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);

        public static int conversationLength_inSeconds { get; set; }

        public static int lastMessageOut_inSeconds { get; set; }

        public static int lastMessageIn_inSeconds { get; set; }

        public static int numberOfAgentMessages { get; set; }

        public static int numberOfUnansweredCustomerMessages { get; set; }

        public void UpdateFlagBasedOnIntrinsics(ChatNew chat)
        {
            bool flagForGoingOverThreshold = CheckAnyIntrinsicOverTheThreshold(chat);

            if (flagForGoingOverThreshold)
            {
                SetFlagUpdate(chat, "Red");
            }
            else
            {
                SetFlagUpdate(chat, "Green");
            }
        }

        private bool CheckAnyIntrinsicOverTheThreshold(ChatNew chat)
        {
            if (CheckIntrinsicOverThreshold(conversationLength_inSeconds, chat.intrinsicData.conversationLength_inSeconds))
            {
                return true;
            }

            if (CheckIntrinsicOverThreshold(lastMessageOut_inSeconds, chat.intrinsicData.lastMessageOut_inSeconds))
            {
                return true;
            }

            if (CheckIntrinsicOverThreshold(lastMessageIn_inSeconds, chat.intrinsicData.lastMessageIn_inSeconds))
            {
                return true;
            }

            if (CheckIntrinsicOverThreshold(numberOfAgentMessages, chat.intrinsicData.numberOfAgentMessages))
            {
                return true;
            }

            if (CheckIntrinsicOverThreshold(numberOfUnansweredCustomerMessages, chat.intrinsicData.numberOfUnansweredCustomerMessages))
            {
                return true;
            }

            //All intrinsics are under their thresholds
            return false;
        }

        private bool CheckIntrinsicOverThreshold(int theThreshold, int theIntrinsic)
        {
            return theIntrinsic >= theThreshold;
        }

        private void SetFlagUpdate(ChatNew chat, string colour)
        {
            log.Debug(String.Format("Setting intrinsics flag to {0} for chat ID [{1}]", colour, chat.guid));
            chat.IntrinsicsFlag = colour;
        }

        public static void UpdateThresholdValues(AgentDataNotification.Thresholds notification)
        {
            ChatIntrinsics.conversationLength_inSeconds = notification.conversationLength_inSeconds.threshold;
            ChatIntrinsics.lastMessageIn_inSeconds = notification.lastMessageIn_inSeconds.threshold;
            ChatIntrinsics.lastMessageOut_inSeconds = notification.lastMessageOut_inSeconds.threshold;
            ChatIntrinsics.numberOfAgentMessages = notification.numberOfAgentMessages.threshold;
            ChatIntrinsics.numberOfUnansweredCustomerMessages = notification.numberOfUnansweredCustomerMessages.threshold;
        }
    }
}