﻿//////////////////////////////////////////////////////////////////////////////
// MultipleAgentDialog.xaml.cs
//
// Copyright © 2008-2014 Avaya Inc. All rights reserved.
// See: www.avaya.com
//////////////////////////////////////////////////////////////////////////////
using Nortel.CCT;
using System.Collections.Generic;
using System.Windows;

namespace CustomDesktop
{
    /// <summary>
    /// Window that handles the scenario where a user has logged in to CCT successfully but multiple Windows users are registered for use.
    /// </summary>
    public partial class MultipleAgentDialog : Window
    {
        /// <summary>
        /// Enum that defines possible results of this dialog.
        /// </summary>
        public enum MultipleAgentDialogResult
        {
            OK,
            CANCEL
        }
        /// <summary>
        /// The currently selected agent. Read only access.
        /// </summary>
        public IAgent SelectedAgent { get { return cbAgents.SelectedItem as IAgent; } }
        private MultipleAgentDialogResult result = MultipleAgentDialogResult.CANCEL; //default to cancel in case the window is closed

        /// <summary>
        /// Constructor. Takes the list of available agents as a parameter.
        /// </summary>
        /// <param name="agents"></param>
        public MultipleAgentDialog(ICollection<IAgent> agents)
        {
            InitializeComponent();
            foreach (IAgent agent in agents)
            {
                cbAgents.Items.Add(agent);
            }
            if (cbAgents.Items.Count > 1)
            {
                cbAgents.SelectedIndex = 0;
            }
        }

        /// <summary>
        /// Shows this window as a dialog and returns the result.
        /// </summary>
        /// <returns></returns>
        public new MultipleAgentDialogResult Show()
        {
            this.ShowDialog();
            return result;
        }

        private void BtnOKClick(object sender, RoutedEventArgs e)
        {
            result = MultipleAgentDialogResult.OK;
            this.Close();
        }

        private void BtnCancelClick(object sender, RoutedEventArgs e)
        {
            result = MultipleAgentDialogResult.CANCEL;
            this.Close();
        }

    }
}
