﻿//////////////////////////////////////////////////////////////////////////////
// AcknowledgementNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AcknowledgementNotificationTest
    {
        [TestMethod]
        public void AcknowledgementNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""acknowledgement"",
                                    ""body"" :
                                    {
                                        ""method"" : ""newMessage"",
                                        ""accepted"" : true
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AcknowledgementNotification note = (AcknowledgementNotification)jdecode.Decode(jsonResponse);

            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "acknowledgement");
            Assert.AreEqual(note.body.method, "newMessage");
            Assert.AreEqual(note.body.accepted, true);
        }

    }


}

