﻿//////////////////////////////////////////////////////////////////////////////
// AgentOperationNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentOperationNotificationTest
    {
        [TestMethod]
        public void AgentOperationNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""operationRequest"",
                                        ""guid"": 12345,
                                        ""success"" : true
                                    }
                                }";

            JDecoder jdecode = new JDecoder();
            AgentOperationNotification note = (AgentOperationNotification)jdecode.Decode(jsonResponse);
            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "operationRequest");
            Assert.AreEqual(note.body.guid, 12345);
            Assert.IsTrue(note.body.success);
        }
    }
}