﻿//////////////////////////////////////////////////////////////////////////////
// AgentLoginNotificationTest.cs
//
// Copyright 2015 Avaya Inc. All Rights Reserved.
//
// Usage of this source is bound to the terms described in
// Licenses/License.txt
//
// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
// Avaya Policy
//////////////////////////////////////////////////////////////////////////////

using EncoderDecoder;
using EncoderDecoder.Notifications;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace EncoderDecoderUnitTest
{
    [TestClass]
    public class AgentLoginNotificationTest
    {
        [TestMethod]
        public void AgentLoginNotificationTest_SimpleDecode1()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentLogin"",
                                        ""loginSuccess"" : true
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentLoginNotification note = (AgentLoginNotification)jdecode.Decode(jsonResponse);
            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentLogin");
            Assert.IsTrue(note.body.loginSuccess);
        }

        [TestMethod]
        public void AgentLoginNotificationTest_SimpleDecode2()
        {
            String jsonResponse = @"{
                                    ""apiVersion"" : ""1.0"",
                                    ""type"" : ""notification"",
                                    ""body"" :
                                    {
                                        ""method"" : ""agentLogin"",
                                        ""loginSuccess"" : false
                                    }
                                }";


            JDecoder jdecode = new JDecoder();
            AgentLoginNotification note = (AgentLoginNotification)jdecode.Decode(jsonResponse);
            Assert.AreEqual(note.apiVersion, "1.0");
            Assert.AreEqual(note.type, "notification");
            Assert.AreEqual(note.body.method, "agentLogin");
            Assert.IsFalse(note.body.loginSuccess);
        }

    }
}
